/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.adapter.patch.api;

import com.mojang.serialization.Codec;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jetbrains.annotations.ApiStatus;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.InstructionAdapter;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.sinytra.adapter.patch.ClassPatchInstance;
import org.sinytra.adapter.patch.InterfacePatchInstance;
import org.sinytra.adapter.patch.PatchInstance;
import org.sinytra.adapter.patch.api.ClassTransform;
import org.sinytra.adapter.patch.api.MethodTransform;
import org.sinytra.adapter.patch.api.PatchEnvironment;
import org.sinytra.adapter.patch.selector.AnnotationHandle;
import org.sinytra.adapter.patch.selector.AnnotationValueHandle;
import org.sinytra.adapter.patch.transformer.ModifyInjectionTarget;
import org.sinytra.adapter.patch.transformer.ModifyMethodAccess;
import org.sinytra.adapter.patch.transformer.ModifyMethodParams;
import org.sinytra.adapter.patch.transformer.ModifyMixinType;
import org.sinytra.adapter.patch.transformer.param.TransformParameters;

public interface Patch {
    public static ClassPatchBuilder builder() {
        return new ClassPatchInstance.ClassPatchBuilderImpl();
    }

    public static InterfacePatchBuilder interfaceBuilder() {
        return new InterfacePatchInstance.InterfaceClassPatchBuilderImpl();
    }

    public Result apply(ClassNode var1, PatchEnvironment var2);

    public Codec<? extends Patch> codec();

    public static interface InterfacePatchBuilder
    extends Builder<InterfacePatchBuilder> {
        public InterfacePatchBuilder targetField(String ... var1);

        public InterfacePatchBuilder modifyValue(String var1);
    }

    public static interface ClassPatchBuilder
    extends Builder<ClassPatchBuilder> {
        public ClassPatchBuilder targetMethod(String ... var1);

        default public ClassPatchBuilder targetInjectionPoint(String target) {
            return this.targetInjectionPoint(null, target);
        }

        public ClassPatchBuilder targetInjectionPoint(String var1, String var2);

        default public ClassPatchBuilder targetConstant(double doubleValue) {
            return (ClassPatchBuilder)this.targetAnnotationValues(handle -> handle.getNested("constant").flatMap(cst -> cst.getValue("doubleValue").map(val -> (Double)val.get() == doubleValue)).orElseGet(() -> handle.getNested("at").flatMap(at -> at.getValue("value").map(s -> ((String)s.get()).equals("CONSTANT") && at.getValue("args").map(AnnotationValueHandle::get).map(t -> t.size() == 1 && (((String)t.get(0)).equals("doubleValue=" + doubleValue + "D") || ((String)t.get(0)).equals("doubleValue=" + doubleValue))).orElse(false) != false)).orElse(false)));
        }

        default public ClassPatchBuilder modifyInjectionPoint(String value, String target) {
            return this.modifyInjectionPoint(value, target, false);
        }

        public ClassPatchBuilder modifyInjectionPoint(String var1, String var2, boolean var3);

        public ClassPatchBuilder modifyInjectionPoint(String var1, String var2, boolean var3, boolean var4);

        default public ClassPatchBuilder modifyInjectionPoint(String target) {
            return this.modifyInjectionPoint(null, target);
        }

        public ClassPatchBuilder redirectShadowMethod(String var1, String var2, BiConsumer<MethodInsnNode, InsnList> var3);

        public ClassPatchBuilder divertRedirector(Consumer<InstructionAdapter> var1);

        public ClassPatchBuilder updateRedirectTarget(String var1, String var2);

        public ClassPatchBuilder disable();
    }

    public static interface Builder<T extends Builder<T>> {
        public T targetClass(String ... var1);

        public T targetMixinType(String ... var1);

        public T targetAnnotationValues(Predicate<AnnotationHandle> var1);

        public T modifyTargetClasses(Consumer<List<Type>> var1);

        @Deprecated
        public T modifyParams(Consumer<ModifyMethodParams.Builder> var1);

        @ApiStatus.Experimental
        public T transformParams(Consumer<TransformParameters.Builder> var1);

        public T modifyTarget(String ... var1);

        public T modifyTarget(ModifyInjectionTarget.Action var1, String ... var2);

        public T modifyVariableIndex(int var1, int var2);

        public T modifyMethodAccess(ModifyMethodAccess.AccessChange ... var1);

        public T extractMixin(String var1);

        public T splitMixin(String var1);

        public T improveModifyVar();

        public T modifyMixinType(String var1, Consumer<ModifyMixinType.Builder> var2);

        public T transform(List<ClassTransform> var1);

        public T transform(ClassTransform var1);

        public T transform(MethodTransform var1);

        public T transformMethods(List<MethodTransform> var1);

        public T chain(Consumer<T> var1);

        public PatchInstance build();
    }

    public static enum Result {
        PASS,
        APPLY,
        COMPUTE_FRAMES;


        public Result or(Result other) {
            if (this == PASS && other != PASS) {
                return other;
            }
            if (this == APPLY && other == COMPUTE_FRAMES) {
                return COMPUTE_FRAMES;
            }
            return this;
        }
    }
}

