/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.adapter.patch.fixes;

import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.Set;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.sinytra.adapter.patch.api.MethodContext;
import org.sinytra.adapter.patch.api.MethodTransform;
import org.sinytra.adapter.patch.api.Patch;
import org.sinytra.adapter.patch.api.PatchContext;
import org.sinytra.adapter.patch.fixes.BytecodeFixerJarGenerator;
import org.sinytra.adapter.patch.fixes.BytecodeFixerUpper;
import org.sinytra.adapter.patch.fixes.TypeAdapter;
import org.sinytra.adapter.patch.selector.FieldMatcher;
import org.sinytra.adapter.patch.util.AdapterUtil;

public class FieldTypePatchTransformer
implements MethodTransform {
    private static final String PREFIX = "adapter$";

    @Override
    public Collection<String> getAcceptedAnnotations() {
        return Set.of("Lorg/spongepowered/asm/mixin/gen/Accessor;");
    }

    @Override
    public Patch.Result apply(ClassNode classNode, MethodNode methodNode, MethodContext methodContext, PatchContext context) {
        String fieldFqn;
        BytecodeFixerUpper bfu = context.environment().bytecodeFixerUpper();
        if (bfu != null && methodContext.targetTypes().size() == 1 && (fieldFqn = (String)AdapterUtil.getAccessorTargetFieldName(classNode.name, methodNode, methodContext.methodAnnotation(), context.environment()).orElse(null)) != null) {
            TypeAdapter typeAdapter;
            String fieldName = new FieldMatcher(fieldFqn).getName();
            Type owner = methodContext.targetTypes().get(0);
            Pair<Type, Type> updatedTypes = bfu.getFieldTypeChange(owner.getInternalName(), fieldName);
            if (updatedTypes != null && (typeAdapter = bfu.getTypeAdapter((Type)updatedTypes.getSecond(), (Type)updatedTypes.getFirst())) != null) {
                String targetMethod = this.addRedirectAcceptorField(owner, methodNode, fieldName, typeAdapter, bfu.getGenerator());
                methodNode.visibleAnnotations.remove(methodContext.methodAnnotation().unwrap());
                AnnotationVisitor invokerAnn = methodNode.visitAnnotation("Lorg/spongepowered/asm/mixin/gen/Invoker;", true);
                invokerAnn.visit("value", (Object)targetMethod);
                return Patch.Result.APPLY;
            }
        }
        return Patch.Result.PASS;
    }

    private String addRedirectAcceptorField(Type owner, MethodNode methodNode, String field, TypeAdapter adapter, BytecodeFixerJarGenerator generator) {
        ClassNode node = this.getOrCreateMixinClass(owner, generator);
        String methodName = PREFIX + field;
        Type to = adapter.to();
        String methodDesc = Type.getMethodDescriptor((Type)to, (Type[])new Type[0]);
        if (node.methods.stream().noneMatch(m -> m.name.equals(methodName))) {
            boolean isStatic = (methodNode.access & 8) == 8;
            MethodNode method = (MethodNode)node.visitMethod(1 | (isStatic ? 8 : 0), methodName, methodDesc, null, null);
            AnnotationVisitor annotationVisitor = method.visitAnnotation("Lorg/spongepowered/asm/mixin/Unique;", true);
            annotationVisitor.visitEnd();
            method.visitCode();
            if (!isStatic) {
                method.visitVarInsn(25, 0);
            }
            method.visitFieldInsn(isStatic ? 178 : 180, owner.getInternalName(), field, adapter.from().getDescriptor());
            adapter.apply(method.instructions, method.instructions.getLast());
            method.visitInsn(FieldTypePatchTransformer.getReturnOpcode(to));
            method.visitEnd();
            method.visitEnd();
        }
        return methodName + methodDesc;
    }

    private ClassNode getOrCreateMixinClass(Type targetClass, BytecodeFixerJarGenerator generator) {
        String className = targetClass.getInternalName().replace('/', '_');
        return generator.getOrCreateClass(className, s -> this.generateFieldAdapterMixin((String)s, targetClass));
    }

    private ClassNode generateFieldAdapterMixin(String className, Type targetClass) {
        ClassNode node = new ClassNode();
        node.visit(52, 33, className, null, "java/lang/Object", null);
        AnnotationVisitor mixinAnnotation = node.visitAnnotation("Lorg/spongepowered/asm/mixin/Mixin;", false);
        AnnotationVisitor valueVisitor = mixinAnnotation.visitArray("value");
        valueVisitor.visit(null, (Object)targetClass);
        valueVisitor.visitEnd();
        mixinAnnotation.visit("priority", (Object)9999);
        mixinAnnotation.visitEnd();
        return node;
    }

    private static int getReturnOpcode(Type type) {
        return switch (type.getSort()) {
            case 9, 10 -> 176;
            case 1, 2, 3, 4, 5 -> 172;
            case 8 -> 175;
            case 6 -> 174;
            case 7 -> 173;
            case 0 -> 177;
            default -> throw new UnsupportedOperationException();
        };
    }
}

