/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.connector.transformer.jar;

import com.mojang.datafixers.util.Pair;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import net.minecraftforge.coremod.api.ASMAPI;
import net.minecraftforge.forgespi.locating.IModFile;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.sinytra.adapter.patch.fixes.BytecodeFixerUpper;
import org.sinytra.adapter.patch.fixes.SimpleTypeAdapter;
import org.sinytra.adapter.patch.fixes.TypeAdapter;
import org.sinytra.connector.ConnectorUtil;
import org.sinytra.connector.transformer.jar.JarTransformer;

public class BytecodeFixerUpperFrontend {
    private static final Map<String, Map<String, Pair<Type, Type>>> FIELD_TYPE_CHANGES = Map.of("net/minecraft/world/item/alchemy/PotionBrewing$Mix", Map.of("f_43532_", Pair.of((Object)Type.getObjectType((String)"java/lang/Object"), (Object)Type.getObjectType((String)"net/minecraft/core/Holder$Reference")), "f_43534_", Pair.of((Object)Type.getObjectType((String)"java/lang/Object"), (Object)Type.getObjectType((String)"net/minecraft/core/Holder$Reference"))), "net/minecraft/world/level/storage/loot/LootTable", Map.of("f_79109_", Pair.of((Object)Type.getType((String)"[Lnet/minecraft/world/level/storage/loot/LootPool;"), (Object)Type.getObjectType((String)"java/util/List"))), "net/minecraft/world/entity/ai/goal/RangedBowAttackGoal", Map.of("f_25782_", Pair.of((Object)Type.getObjectType((String)"net/minecraft/world/entity/monster/Monster"), (Object)Type.getObjectType((String)"net/minecraft/world/entity/Mob"))));
    private static final List<TypeAdapter> FIELD_TYPE_ADAPTERS = List.of(new SimpleTypeAdapter(Type.getObjectType((String)"net/minecraft/core/Holder$Reference"), Type.getObjectType((String)"java/lang/Object"), (list, insn) -> list.insert(insn, (AbstractInsnNode)new MethodInsnNode(182, "net/minecraft/core/Holder$Reference", "get", "()Ljava/lang/Object;"))), new SimpleTypeAdapter(Type.getObjectType((String)"net/minecraft/resources/ResourceLocation"), Type.getObjectType((String)"java/lang/String"), (list, insn) -> list.insert(insn, (AbstractInsnNode)new MethodInsnNode(182, "net/minecraft/resources/ResourceLocation", "toString", "()Ljava/lang/String;"))), new SimpleTypeAdapter(Type.getObjectType((String)"net/minecraft/world/item/ItemStack"), Type.getObjectType((String)"net/minecraft/world/item/Item"), (list, insn) -> list.insert(insn, (AbstractInsnNode)new MethodInsnNode(182, "net/minecraft/world/item/ItemStack", ASMAPI.mapMethod((String)"m_41720_"), "()Lnet/minecraft/world/item/Item;"))), new SimpleTypeAdapter(Type.getObjectType((String)"java/util/List"), Type.getType((String)"[Lnet/minecraft/world/level/storage/loot/LootPool;"), (list, insn) -> list.insert(insn, ASMAPI.listOf((AbstractInsnNode[])new AbstractInsnNode[]{new InsnNode(3), new TypeInsnNode(189, "net/minecraft/world/level/storage/loot/LootPool"), new MethodInsnNode(185, "java/util/List", "toArray", "([Ljava/lang/Object;)[Ljava/lang/Object;", true), new TypeInsnNode(192, "[Lnet/minecraft/world/level/storage/loot/LootPool;")}))), new SimpleTypeAdapter(Type.getObjectType((String)"net/minecraft/world/entity/Mob"), Type.getObjectType((String)"net/minecraft/world/entity/monster/Monster"), (list, insn) -> {}), new SimpleTypeAdapter(Type.getObjectType((String)"net/minecraft/world/item/enchantment/Enchantment"), Type.getObjectType((String)"net/minecraft/world/item/enchantment/EnchantmentCategory"), (list, insn) -> list.insert(insn, (AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/world/item/enchantment/Enchantment", ASMAPI.mapField((String)"f_44672_"), "Lnet/minecraft/world/item/enchantment/EnchantmentCategory;"))));
    private final BytecodeFixerUpper bfu = new BytecodeFixerUpper(FIELD_TYPE_CHANGES, FIELD_TYPE_ADAPTERS);
    private final ConnectorUtil.CacheFile cacheFile;

    public BytecodeFixerUpperFrontend() {
        Path path = JarTransformer.getGeneratedJarPath();
        this.cacheFile = ConnectorUtil.getCached(null, path);
        if (this.cacheFile.isUpToDate()) {
            this.bfu.getGenerator().loadExisting(path);
        }
    }

    public BytecodeFixerUpper unwrap() {
        return this.bfu;
    }

    public void saveGeneratedAdapterJar() throws IOException {
        Path path = JarTransformer.getGeneratedJarPath();
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        Files.deleteIfExists(path);
        Attributes attributes = new Attributes();
        attributes.putValue("FMLModType", IModFile.Type.GAMELIBRARY.name());
        if (this.bfu.getGenerator().save(path, attributes)) {
            this.cacheFile.save();
        }
    }
}

