/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.ribbits.entity.trade;

import com.yungnickyoung.minecraft.ribbits.entity.trade.ItemListing;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;

public class EnchantedItemForAmethyst
implements ItemListing {
    private final ItemStack itemStack;
    private final int amethystCostMin;
    private final int amethystCostMax;
    private final int maxUses;
    private final float priceMultiplier;

    public EnchantedItemForAmethyst(Item item, int amethystCostMin, int amethystCostMax, int maxUses) {
        this(item, amethystCostMin, amethystCostMax, maxUses, 0.05f);
    }

    public EnchantedItemForAmethyst(Item item, int costMin, int costMax, int maxUses, float priceMultiplier) {
        this.itemStack = new ItemStack((ItemLike)item);
        this.amethystCostMin = costMin;
        this.amethystCostMax = costMax;
        this.maxUses = maxUses;
        this.priceMultiplier = priceMultiplier;
    }

    @Override
    public MerchantOffer getOffer(Entity entity, RandomSource rand) {
        int randomEnchantCost = 5 + rand.m_188503_(15);
        ItemStack outputItem = EnchantmentHelper.m_220292_((RandomSource)rand, (ItemStack)new ItemStack((ItemLike)this.itemStack.m_41720_()), (int)randomEnchantCost, (boolean)false);
        int cost = rand.m_216332_(this.amethystCostMin, this.amethystCostMax);
        ItemStack amethyst = new ItemStack((ItemLike)Items.f_151049_, cost);
        return new MerchantOffer(amethyst, outputItem, this.maxUses, 0, this.priceMultiplier);
    }
}

