/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.ribbits.network;

import com.yungnickyoung.minecraft.ribbits.network.ClientPacketHandlerForge;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class RibbitMusicStartSingleS2CPacket {
    private final UUID ribbitId;
    private final ResourceLocation instrumentId;
    private final int tickOffset;

    public RibbitMusicStartSingleS2CPacket(UUID ribbitId, ResourceLocation instrumentId, int tickOffset) {
        this.ribbitId = ribbitId;
        this.instrumentId = instrumentId;
        this.tickOffset = tickOffset;
    }

    public RibbitMusicStartSingleS2CPacket(FriendlyByteBuf buf) {
        this.ribbitId = buf.m_130259_();
        this.instrumentId = buf.m_130281_();
        this.tickOffset = buf.readInt();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130077_(this.ribbitId);
        buf.m_130085_(this.instrumentId);
        buf.writeInt(this.tickOffset);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> this.lambda$handle$1((Supplier)ctx)));
        ctx.get().setPacketHandled(true);
        return true;
    }

    public UUID getRibbitId() {
        return this.ribbitId;
    }

    public ResourceLocation getInstrumentId() {
        return this.instrumentId;
    }

    public int getTickOffset() {
        return this.tickOffset;
    }

    private /* synthetic */ Runnable lambda$handle$1(Supplier ctx) {
        return () -> this.lambda$handle$0((Supplier)ctx);
    }

    private /* synthetic */ void lambda$handle$0(Supplier ctx) {
        ClientPacketHandlerForge.handleStartSingleRibbitInstrument(this, ctx);
    }
}

