/*
 * Decompiled with CFR 0.152.
 */
package com.gharielsl.tf_dnv.entity.model;

import com.gharielsl.tf_dnv.entity.TwilightTrader;
import com.gharielsl.tf_dnv.entity.model.TwilightTraderAnimations;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class TwilightTraderModel<T extends TwilightTrader>
extends HierarchicalModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("tf_dnv", "twilight_trader"), "main");
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart left_arm;
    private final ModelPart right_arm;
    private final ModelPart bone3;
    private final ModelPart bone;
    private final ModelPart bone2;

    public TwilightTraderModel(ModelPart root) {
        this.root = root.m_171324_("root");
        this.head = this.root.m_171324_("head");
        this.body = this.root.m_171324_("body");
        this.left_arm = this.root.m_171324_("left_arm");
        this.right_arm = this.root.m_171324_("right_arm");
        this.bone3 = this.right_arm.m_171324_("bone3");
        this.bone = this.root.m_171324_("bone");
        this.bone2 = this.root.m_171324_("bone2");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition root = partdefinition.m_171599_("root", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition head = root.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 13).m_171488_(-1.5f, -4.0f, -1.5f, 3.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(0, 7).m_171488_(-2.0f, -6.0f, -2.0f, 4.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(8, 20).m_171488_(1.5f, -3.0f, -1.0f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(4, 30).m_171488_(-2.5f, -3.0f, -1.0f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-9.0f, (float)0.0f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition body = root.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(16, 0).m_171488_(-1.5f, 0.0f, -1.0f, 3.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-9.0f, (float)0.0f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r1 = body.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.0f, -3.0f, 0.0f, 5.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.5f, (float)3.1f, (float)-0.3f, (float)0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r2 = body.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(12, 13).m_171488_(-1.0f, -2.0f, 0.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.5f, (float)4.9f, (float)-0.3f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition left_arm = root.m_171599_("left_arm", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)2.0f, (float)-8.5f, (float)0.0f));
        PartDefinition left_arm_r1 = left_arm.m_171599_("left_arm_r1", CubeListBuilder.m_171558_().m_171514_(24, 14).m_171488_(1.5f, -3.0f, -1.0f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(16, 6).m_171488_(1.5f, -6.0f, 1.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.7f, (float)5.5f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)-0.0873f));
        PartDefinition right_arm = root.m_171599_("right_arm", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-2.0f, (float)-8.5f, (float)0.0f));
        PartDefinition right_arm_r1 = right_arm.m_171599_("right_arm_r1", CubeListBuilder.m_171558_().m_171514_(24, 23).m_171488_(-3.5f, -3.0f, -1.0f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(0, 20).m_171488_(-3.5f, -6.0f, 1.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.7f, (float)5.5f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)0.0873f));
        PartDefinition bone3 = right_arm.m_171599_("bone3", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)0.0f, (float)3.0f, (float)-3.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r3 = bone3.m_171599_("cube_r3", CubeListBuilder.m_171558_().m_171514_(16, 27).m_171488_(-3.0f, -2.0f, -1.0f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)2.0f, (float)-1.9f, (float)-3.1f, (float)1.1781f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r4 = bone3.m_171599_("cube_r4", CubeListBuilder.m_171558_().m_171514_(26, 4).m_171488_(-3.0f, -2.0f, 0.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)2.0f, (float)-2.1f, (float)-3.2f, (float)0.7418f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r5 = bone3.m_171599_("cube_r5", CubeListBuilder.m_171558_().m_171514_(10, 27).m_171488_(-1.0f, -2.0f, -1.0f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-3.4f, (float)-0.5f, (float)-0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r6 = bone3.m_171599_("cube_r6", CubeListBuilder.m_171558_().m_171514_(24, 17).m_171488_(-1.0f, -2.0f, -1.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-3.6f, (float)-0.6f, (float)0.3054f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r7 = bone3.m_171599_("cube_r7", CubeListBuilder.m_171558_().m_171514_(4, 27).m_171488_(-1.0f, -2.0f, -1.0f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-3.0f, (float)-2.0f, (float)0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r8 = bone3.m_171599_("cube_r8", CubeListBuilder.m_171558_().m_171514_(0, 26).m_171488_(-1.0f, -6.0f, -1.0f, 1.0f, 6.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)1.0f, (float)1.0f, (float)0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition bone = root.m_171599_("bone", CubeListBuilder.m_171558_().m_171514_(12, 19).m_171488_(-1.0f, 0.0f, -2.4f, 2.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(26, 0).m_171488_(-1.1f, -2.0f, -1.0f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.2f, (float)-0.9f, (float)0.9f));
        PartDefinition cube_r9 = bone.m_171599_("cube_r9", CubeListBuilder.m_171558_().m_171514_(24, 6).m_171488_(-1.0f, -2.0f, 0.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.3f, (float)-2.0f, (float)0.0f, (float)0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r10 = bone.m_171599_("cube_r10", CubeListBuilder.m_171558_().m_171514_(8, 23).m_171488_(-1.0f, -2.0f, 0.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-1.0f, (float)-1.0f, (float)0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition bone2 = root.m_171599_("bone2", CubeListBuilder.m_171558_().m_171514_(22, 19).m_171488_(-1.0f, 0.0f, -2.4f, 2.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(24, 26).m_171488_(-0.9f, -2.0f, -1.0f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.2f, (float)-0.9f, (float)0.9f));
        PartDefinition cube_r11 = bone2.m_171599_("cube_r11", CubeListBuilder.m_171558_().m_171514_(24, 10).m_171488_(-1.0f, -2.0f, 0.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.3f, (float)-2.0f, (float)0.0f, (float)0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r12 = bone2.m_171599_("cube_r12", CubeListBuilder.m_171558_().m_171514_(16, 23).m_171488_(-1.0f, -2.0f, 0.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-1.0f, (float)-1.0f, (float)0.2182f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    private void applyHeadRotation(float pNetHeadYaw, float pHeadPitch, float pAgeInTicks) {
        pNetHeadYaw = Mth.m_14036_((float)pNetHeadYaw, (float)-30.0f, (float)30.0f);
        pHeadPitch = Mth.m_14036_((float)pHeadPitch, (float)-25.0f, (float)45.0f);
        this.head.f_104204_ = pNetHeadYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = pHeadPitch * ((float)Math.PI / 180);
    }

    public void setupAnim(TwilightTrader entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        this.applyHeadRotation(netHeadYaw, headPitch, ageInTicks);
        this.m_267799_(TwilightTraderAnimations.walk, limbSwing * 3.0f, limbSwingAmount * 3.0f, 2.0f, 2.5f);
        this.m_233385_(entity.idleAnimationState, TwilightTraderAnimations.idle, ageInTicks, 1.0f);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.root.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public ModelPart m_142109_() {
        return this.root;
    }
}

