/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.alshanex_familiars.block.entity;

import javax.annotation.Nonnull;
import net.alshanex.alshanex_familiars.registry.BlockEntityRegistry;
import net.alshanex.alshanex_familiars.registry.ItemRegistry;
import net.alshanex.alshanex_familiars.registry.ParticleRegistry;
import net.alshanex.alshanex_familiars.screen.PetBedMenu;
import net.alshanex.alshanex_familiars.util.CylinderParticleManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class PetBedBlockEntity
extends BlockEntity
implements MenuProvider {
    private PetBedMenu menu;
    private final ItemStackHandler itemHandler = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            PetBedBlockEntity.this.m_6596_();
            if (!((PetBedBlockEntity)PetBedBlockEntity.this).f_58857_.f_46443_) {
                PetBedBlockEntity.this.f_58857_.m_7260_(PetBedBlockEntity.this.m_58899_(), PetBedBlockEntity.this.m_58900_(), PetBedBlockEntity.this.m_58900_(), 3);
            }
        }
    };
    private final LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    private int counter = 0;

    public PetBedBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityRegistry.PET_BED.get(), pos, state);
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    public Component m_5446_() {
        return Component.m_237113_((String)"Familiar Bed");
    }

    public ItemStack getRenderStack() {
        return this.itemHandler.getStackInSlot(0);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int containerId, Inventory playerInventory, Player player) {
        this.menu = new PetBedMenu(containerId, playerInventory, this);
        return this.menu;
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        if (pTag.m_128441_("inventory")) {
            this.itemHandler.deserializeNBT(pTag.m_128469_("inventory"));
        }
    }

    public void m_183515_(@Nonnull CompoundTag tag) {
        tag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        if (tag != null) {
            this.m_142466_(tag);
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        ClientboundBlockEntityDataPacket packet = ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
        return packet;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.handleUpdateTag(pkt.m_131708_());
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @javax.annotation.Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.lazyItemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void tick(Level pLevel, BlockPos pPos, BlockState pState) {
        ItemStack stack = this.itemHandler.getStackInSlot(0);
        if (stack != null && stack != ItemStack.f_41583_ && stack.m_150930_((Item)ItemRegistry.FAMILIAR_TOME.get()) && stack.m_41782_()) {
            CompoundTag nbt = stack.m_41783_();
            float maxHealth = nbt.m_128457_("maxHealth");
            float currentHealth = nbt.m_128457_("currentHealth");
            ++this.counter;
            if (this.counter % 20 == 0) {
                CylinderParticleManager.spawnParticlesAtBlockPos(pLevel, pPos.m_252807_(), 1, (ParticleOptions)ParticleRegistry.SLEEP_PARTICLE.get(), CylinderParticleManager.ParticleDirection.UPWARD, 0.1, 0.0, 0.8);
            }
            if (this.counter >= 40) {
                if (currentHealth < maxHealth) {
                    nbt.m_128350_("currentHealth", currentHealth += 1.0f);
                }
                this.counter = 0;
            }
        }
    }
}

