/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.alshanex_familiars.entity.sound;

import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.entity.spells.AoeEntity;
import io.redspace.ironsspellbooks.registries.MobEffectRegistry;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.alshanex.alshanex_familiars.registry.EntityRegistry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class HealingCircleEntity
extends AoeEntity
implements GeoEntity {
    private int effectAmplifier;
    @Nullable
    private LivingEntity owner;
    @Nullable
    private UUID ownerUUID;
    private DamageSource damageSource;
    private final RawAnimation idle = RawAnimation.begin().thenLoop("idle");
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public HealingCircleEntity(EntityType<? extends Projectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public HealingCircleEntity(Level level, int effectAmplifier, LivingEntity owner) {
        this((EntityType<? extends Projectile>)((EntityType)EntityRegistry.HEALING_CIRCLE.get()), level);
        this.effectAmplifier = effectAmplifier;
        this.setOwner(owner);
    }

    public void applyEffect(LivingEntity target) {
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.getOwner() != null && this.f_19797_ % 5 == 0) {
            int radiusSqr = 16;
            this.m_9236_().m_6443_(LivingEntity.class, new AABB(this.m_20182_().m_82492_(4.0, 4.0, 4.0), this.m_20182_().m_82520_(4.0, 4.0, 4.0)), livingEntity -> this.horizontalDistanceSqr((LivingEntity)livingEntity, this.m_20182_()) < (float)radiusSqr && (Utils.shouldHealEntity((LivingEntity)this.getOwner(), (LivingEntity)livingEntity) || livingEntity.m_7306_((Entity)this.getOwner())) && !livingEntity.m_21023_(MobEffects.f_19605_)).forEach(livingEntity -> {
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 100, Math.min(2, this.effectAmplifier), false, false, true));
                livingEntity.m_7292_(new MobEffectInstance((MobEffect)MobEffectRegistry.OAKSKIN.get(), 100, this.effectAmplifier, false, false, true));
            });
        }
    }

    private float horizontalDistanceSqr(LivingEntity livingEntity, Vec3 vec3) {
        double dx = livingEntity.m_20185_() - vec3.f_82479_;
        double dz = livingEntity.m_20189_() - vec3.f_82481_;
        return (float)(dx * dx + dz * dz);
    }

    public float getParticleCount() {
        return 0.0f;
    }

    public Optional<ParticleOptions> getParticle() {
        return Optional.empty();
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128403_("Owner")) {
            this.ownerUUID = pCompound.m_128342_("Owner");
        }
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        if (this.ownerUUID != null) {
            pCompound.m_128362_("Owner", this.ownerUUID);
        }
    }

    public void setOwner(@Nullable LivingEntity pOwner) {
        this.owner = pOwner;
        this.ownerUUID = pOwner == null ? null : pOwner.m_20148_();
    }

    @Nullable
    public LivingEntity getOwner() {
        Entity entity;
        if (this.owner == null && this.ownerUUID != null && this.m_9236_() instanceof ServerLevel && (entity = ((ServerLevel)this.m_9236_()).m_8791_(this.ownerUUID)) instanceof LivingEntity) {
            this.owner = (LivingEntity)entity;
        }
        return this.owner;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "idle", 0, this::idlePredicate)});
    }

    private PlayState idlePredicate(AnimationState event) {
        event.getController().setAnimation(this.idle);
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

