/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.alshanex_familiars.item;

import java.util.List;
import net.alshanex.alshanex_familiars.entity.generic.AbstractSpellCastingPet;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class FamiliarTomeItem
extends Item {
    public FamiliarTomeItem(Item.Properties properties) {
        super(properties.m_41487_(1).m_41497_(Rarity.UNCOMMON));
    }

    public InteractionResult m_6225_(UseOnContext context) {
        ItemStack stack;
        Level worldIn;
        Direction facing;
        BlockPos pos;
        Player player = context.m_43723_();
        if (!this.release(player, pos = context.m_8083_(), facing = context.m_43719_(), worldIn = context.m_43725_(), stack = context.m_43722_())) {
            return InteractionResult.FAIL;
        }
        return InteractionResult.SUCCESS;
    }

    public InteractionResult m_6880_(ItemStack stack, Player playerIn, LivingEntity target, InteractionHand hand) {
        if (!this.capture(stack, target, playerIn)) {
            return InteractionResult.FAIL;
        }
        playerIn.m_6674_(hand);
        playerIn.m_21008_(hand, stack);
        return InteractionResult.SUCCESS;
    }

    public boolean capture(ItemStack stack, LivingEntity target, Player player) {
        AbstractSpellCastingPet pet;
        if (target.m_20193_().f_46443_) {
            return false;
        }
        if (!(target instanceof AbstractSpellCastingPet) || (pet = (AbstractSpellCastingPet)target).getSummoner() == null || !pet.getSummoner().m_7306_((Entity)player)) {
            return false;
        }
        if (this.containsEntity(stack)) {
            return false;
        }
        CompoundTag nbt = new CompoundTag();
        if (target.m_8077_()) {
            nbt.m_128359_("name", target.m_7770_().getString());
        }
        nbt.m_128350_("maxHealth", target.m_21233_());
        nbt.m_128350_("currentHealth", target.m_21223_());
        nbt.m_128359_("entity", EntityType.m_20613_((EntityType)target.m_6095_()).toString());
        target.m_20240_(nbt);
        stack.m_41751_(nbt);
        target.m_142687_(Entity.RemovalReason.DISCARDED);
        return true;
    }

    public boolean release(Player player, BlockPos pos, Direction facing, Level worldIn, ItemStack stack) {
        AbstractSpellCastingPet pet;
        if (player.m_20193_().f_46443_) {
            return false;
        }
        if (!this.containsEntity(stack)) {
            return false;
        }
        Entity entity = this.getEntityFromStack(stack, worldIn, true);
        if (entity instanceof AbstractSpellCastingPet && (pet = (AbstractSpellCastingPet)entity).getSummoner() != null && !pet.getSummoner().m_7306_((Entity)player)) {
            return false;
        }
        if (stack.m_41782_() && stack.m_41783_().m_128441_("currentHealth")) {
            CompoundTag nbt = stack.m_41783_();
            float currentHealth = nbt.m_128457_("currentHealth");
            if (entity instanceof AbstractSpellCastingPet) {
                AbstractSpellCastingPet pet2 = (AbstractSpellCastingPet)entity;
                pet2.m_21153_(currentHealth);
            }
        }
        BlockPos blockPos = pos.m_121945_(facing);
        entity.m_19890_((double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_(), (double)blockPos.m_123343_() + 0.5, 0.0f, 0.0f);
        stack.m_41751_(null);
        worldIn.m_7967_(entity);
        return true;
    }

    public boolean containsEntity(ItemStack stack) {
        return !stack.m_41619_() && stack.m_41782_() && stack.m_41783_().m_128441_("entity");
    }

    @javax.annotation.Nullable
    public Entity getEntityFromStack(ItemStack stack, Level world, boolean withInfo) {
        CompoundTag nbt;
        EntityType type;
        if (stack.m_41782_() && (type = (EntityType)EntityType.m_20632_((String)(nbt = stack.m_41783_()).m_128461_("entity")).orElse(null)) != null) {
            Entity entity = type.m_20615_(world);
            if (withInfo) {
                entity.m_20258_(nbt);
            } else if (!type.m_20654_()) {
                return null;
            }
            return entity;
        }
        return null;
    }

    public String getID(ItemStack stack) {
        return stack.m_41783_().m_128461_("entity");
    }

    public Component m_7626_(ItemStack stack) {
        if (!this.containsEntity(stack)) {
            return Component.m_237115_((String)super.m_5671_(stack));
        }
        return Component.m_237115_((String)super.m_5671_(stack)).m_130946_(" (" + this.getID(stack) + ")");
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
        if (pStack.m_41782_()) {
            CompoundTag nbt = pStack.m_41783_();
            float maxHealth = nbt.m_128457_("maxHealth");
            float currentHealth = nbt.m_128457_("currentHealth");
            ChatFormatting format = currentHealth < maxHealth ? ChatFormatting.RED : ChatFormatting.GREEN;
            pTooltipComponents.add((Component)Component.m_237113_((String)("Current health: " + currentHealth + "/" + maxHealth)).m_130940_(format));
        }
    }
}

