/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.alshanex_familiars.item;

import io.redspace.ironsspellbooks.api.util.Utils;
import java.util.List;
import net.alshanex.alshanex_familiars.entity.generic.AbstractSpellCastingPet;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class PandoraBox
extends Item {
    public PandoraBox(Item.Properties properties) {
        super(properties.m_41487_(1).m_41497_(Rarity.EPIC));
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        Level worldIn = context.m_43725_();
        ItemStack stack = context.m_43722_();
        if (stack.m_41782_() && stack.m_41783_().m_128441_("Familiar0")) {
            if (!this.release(player, worldIn, stack)) {
                return InteractionResult.FAIL;
            }
        } else {
            List<LivingEntity> pets = worldIn.m_6443_(LivingEntity.class, player.m_20191_().m_82400_(15.0), entity -> {
                AbstractSpellCastingPet pet;
                return entity instanceof AbstractSpellCastingPet && (pet = (AbstractSpellCastingPet)((Object)entity)).getSummoner() != null && pet.getSummoner().m_7306_((Entity)player) && !entity.m_20193_().f_46443_;
            }).stream().toList();
            if (pets.isEmpty()) {
                return InteractionResult.FAIL;
            }
            if (!this.capture(stack, pets)) {
                return InteractionResult.FAIL;
            }
        }
        return InteractionResult.SUCCESS;
    }

    public boolean capture(ItemStack stack, List<LivingEntity> targets) {
        CompoundTag tag = stack.m_41784_();
        for (int i = 0; i < Math.min(10, targets.size()); ++i) {
            CompoundTag nbt = new CompoundTag();
            LivingEntity target = targets.get(i);
            nbt.m_128350_("currentHealthPet", target.m_21223_());
            nbt.m_128359_("entity", EntityType.m_20613_((EntityType)target.m_6095_()).toString());
            target.m_20240_(nbt);
            tag.m_128365_("Familiar" + i, (Tag)nbt);
            target.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        return true;
    }

    public boolean release(Player player, Level worldIn, ItemStack stack) {
        if (player.m_20193_().f_46443_) {
            return false;
        }
        if (stack.m_41782_()) {
            CompoundTag tag = stack.m_41783_();
            for (int i = 0; i < 10; ++i) {
                AbstractSpellCastingPet pet;
                if (!tag.m_128441_("Familiar" + i)) continue;
                CompoundTag nbt = tag.m_128469_("Familiar" + i);
                Entity entity = this.getEntityFromStack(nbt, worldIn, true);
                if (entity instanceof AbstractSpellCastingPet && (pet = (AbstractSpellCastingPet)entity).getSummoner() != null && !pet.getSummoner().m_7306_((Entity)player)) {
                    return false;
                }
                float currentHealth = nbt.m_128457_("currentHealthPet");
                if (entity instanceof AbstractSpellCastingPet) {
                    AbstractSpellCastingPet pet2 = (AbstractSpellCastingPet)entity;
                    pet2.m_21153_(currentHealth);
                }
                float yrot = 0.62810004f * (float)i + entity.m_146908_() * ((float)Math.PI / 180);
                Vec3 spawn = Utils.moveToRelativeGroundLevel((Level)worldIn, (Vec3)player.m_146892_().m_82549_(new Vec3((double)(5.0f * Mth.m_14089_((float)yrot)), 0.0, (double)(5.0f * Mth.m_14031_((float)yrot)))), (int)10);
                entity.m_6034_(spawn.f_82479_, spawn.f_82480_, spawn.f_82481_);
                entity.m_146922_(entity.m_146908_());
                entity.m_146867_();
                worldIn.m_7967_(entity);
            }
            stack.m_41751_(new CompoundTag());
            return true;
        }
        return false;
    }

    @javax.annotation.Nullable
    public Entity getEntityFromStack(CompoundTag nbt, Level world, boolean withInfo) {
        EntityType type = EntityType.m_20632_((String)nbt.m_128461_("entity")).orElse(null);
        if (type != null) {
            Entity entity = type.m_20615_(world);
            if (withInfo) {
                entity.m_20258_(nbt);
            } else if (!type.m_20654_()) {
                return null;
            }
            return entity;
        }
        return null;
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
        int numPets = 0;
        if (pStack.m_41782_()) {
            CompoundTag tag = pStack.m_41784_();
            for (int i = 0; i < 10; ++i) {
                if (!tag.m_128441_("Familiar" + i)) continue;
                ++numPets;
            }
        }
        pTooltipComponents.add((Component)Component.m_237113_((String)("Stored familiars: " + numPets)).m_130940_(ChatFormatting.AQUA));
    }
}

