/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.alshanex_familiars.mixin;

import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.ICastData;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.capabilities.magic.TargetEntityCastData;
import io.redspace.ironsspellbooks.entity.spells.HealingAoe;
import io.redspace.ironsspellbooks.entity.spells.target_area.TargetedAreaEntity;
import io.redspace.ironsspellbooks.particle.BlastwaveParticleOptions;
import io.redspace.ironsspellbooks.spells.holy.HealingCircleSpell;
import net.alshanex.alshanex_familiars.entity.ClericPetEntity;
import net.alshanex.alshanex_familiars.entity.NecromancerPetEntity;
import net.alshanex.alshanex_familiars.entity.generic.AbstractTerrestrianSpellCastingPet;
import net.alshanex.alshanex_familiars.registry.EntityRegistry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(value={HealingCircleSpell.class})
public abstract class CleanseSpellMixin
extends AbstractSpell {
    public void onCast(Level world, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        TargetEntityCastData castTargetingData;
        LivingEntity target;
        Vec3 spawn = null;
        ICastData iCastData = playerMagicData.getAdditionalCastData();
        if (iCastData instanceof TargetEntityCastData && (target = (castTargetingData = (TargetEntityCastData)iCastData).getTarget((ServerLevel)world)) != null) {
            spawn = target.m_20182_();
        }
        if (spawn == null) {
            spawn = Utils.raycastForEntity((Level)world, (Entity)entity, (float)32.0f, (boolean)true, (float)0.15f).m_82450_();
            spawn = Utils.moveToRelativeGroundLevel((Level)world, (Vec3)spawn, (int)6);
        }
        int duration = this.getDuration(spellLevel, entity);
        float radius = this.getRadius(spellLevel, entity);
        world.m_45976_(LivingEntity.class, AABB.m_165882_((Vec3)entity.m_20191_().m_82399_(), (double)radius, (double)radius, (double)radius)).forEach(livingEntity -> {
            NecromancerPetEntity pet;
            if (livingEntity instanceof NecromancerPetEntity && (pet = (NecromancerPetEntity)((Object)livingEntity)).getSummoner() == null) {
                ClericPetEntity cleric = new ClericPetEntity((EntityType<? extends AbstractTerrestrianSpellCastingPet>)((EntityType)EntityRegistry.CLERIC_PET.get()), pet.m_9236_());
                cleric.m_6034_(pet.m_20185_(), pet.m_20186_(), pet.m_20189_());
                cleric.m_146922_(pet.m_146908_());
                pet.m_9236_().m_7967_((Entity)cleric);
                MagicManager.spawnParticles((Level)pet.m_9236_(), (ParticleOptions)new BlastwaveParticleOptions(((SchoolType)SchoolRegistry.HOLY.get()).getTargetingColor(), 2.0f), (double)pet.m_20185_(), (double)(pet.m_20186_() + (double)0.165f), (double)pet.m_20189_(), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)true);
                pet.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        });
        HealingAoe aoeEntity = new HealingAoe(world);
        aoeEntity.m_5602_((Entity)entity);
        aoeEntity.setCircular();
        aoeEntity.setRadius(radius);
        aoeEntity.setDuration(duration);
        aoeEntity.setDamage(this.getHealing(spellLevel, entity));
        aoeEntity.m_146884_(spawn);
        world.m_7967_((Entity)aoeEntity);
        TargetedAreaEntity visualEntity = TargetedAreaEntity.createTargetAreaEntity((Level)world, (Vec3)spawn, (float)radius, (int)0xC80000);
        visualEntity.setDuration(duration);
        visualEntity.setOwner((Entity)aoeEntity);
        visualEntity.setShouldFade(true);
        super.onCast(world, spellLevel, entity, castSource, playerMagicData);
    }

    private float getHealing(int spellLevel, LivingEntity caster) {
        return this.getSpellPower(spellLevel, (Entity)caster) * 0.25f;
    }

    private float getRadius(int spellLevel, LivingEntity caster) {
        return 5.0f;
    }

    private int getDuration(int spellLevel, LivingEntity caster) {
        return 200;
    }
}

