/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.alshanex_familiars.spells;

import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellAnimations;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.AnimationHolder;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.RecastInstance;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.alshanex.alshanex_familiars.entity.sound.BlackNoteEntity;
import net.alshanex.alshanex_familiars.entity.sound.DefaultNoteEntity;
import net.alshanex.alshanex_familiars.registry.AFSchoolRegistry;
import net.alshanex.alshanex_familiars.registry.AFSoundRegistry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

@AutoSpellConfig
public class DefaultNoteSpell
extends AbstractSpell {
    private final ResourceLocation spellId = new ResourceLocation("alshanex_familiars", "default_note");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.RARE).setSchoolResource(AFSchoolRegistry.SOUND_RESOURCE).setMaxLevel(5).setCooldownSeconds(30.0).build();

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.m_237110_((String)"ui.irons_spellbooks.damage", (Object[])new Object[]{Utils.stringTruncation((double)this.getDamage(spellLevel, caster), (int)2)}), Component.m_237110_((String)"ui.irons_spellbooks.blast_count", (Object[])new Object[]{this.getRecastCount(spellLevel, caster)}), Component.m_237110_((String)"ui.irons_spellbooks.effect_length", (Object[])new Object[]{"25s"}));
    }

    public DefaultNoteSpell() {
        this.manaCostPerLevel = 10;
        this.baseSpellPower = 10;
        this.spellPowerPerLevel = 1;
        this.castTime = 0;
        this.baseManaCost = 90;
    }

    public boolean allowLooting() {
        return false;
    }

    public CastType getCastType() {
        return CastType.INSTANT;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public Optional<SoundEvent> getCastStartSound() {
        return Optional.empty();
    }

    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.of((SoundEvent)AFSoundRegistry.HARP_WAVE.get());
    }

    public int getRecastCount(int spellLevel, @Nullable LivingEntity entity) {
        return 2 + spellLevel;
    }

    public void onCast(Level world, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        int remainingCasts;
        if (!playerMagicData.getPlayerRecasts().hasRecastForSpell(this.getSpellId())) {
            playerMagicData.getPlayerRecasts().addRecast(new RecastInstance(this.getSpellId(), spellLevel, this.getRecastCount(spellLevel, entity), 80, castSource, null), playerMagicData);
        }
        if ((remainingCasts = playerMagicData.getPlayerRecasts().getRemainingRecastsForSpell((AbstractSpell)this)) == 1) {
            BlackNoteEntity blackNote = new BlackNoteEntity(world, entity);
            blackNote.m_146884_(entity.m_20182_().m_82520_(0.0, (double)entity.m_20192_() - blackNote.m_20191_().m_82376_() * 0.5, 0.0));
            blackNote.setRotation(entity.m_146909_(), entity.m_146908_());
            blackNote.setDamage(this.getDamage(spellLevel, entity));
            blackNote.shoot(entity.m_20154_());
            world.m_7967_((Entity)blackNote);
        } else if (remainingCasts > 1) {
            DefaultNoteEntity defaultNote = new DefaultNoteEntity(world, entity);
            defaultNote.m_146884_(entity.m_20182_().m_82520_(0.0, (double)entity.m_20192_() - defaultNote.m_20191_().m_82376_() * 0.5, 0.0));
            defaultNote.setRotation(entity.m_146909_(), entity.m_146908_());
            defaultNote.setDamage(this.getDamage(spellLevel, entity));
            defaultNote.shoot(entity.m_20154_());
            world.m_7967_((Entity)defaultNote);
        }
        super.onCast(world, spellLevel, entity, castSource, playerMagicData);
    }

    private float getDamage(int spellLevel, LivingEntity entity) {
        return this.getSpellPower(spellLevel, (Entity)entity);
    }

    public AnimationHolder getCastStartAnimation() {
        return SpellAnimations.SLASH_ANIMATION;
    }
}

