/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.fruitsdelight.content.block;

import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import com.tterrag.registrate.providers.loot.RegistrateBlockLootTables;
import dev.xkmc.fruitsdelight.content.block.BaseLeavesBlock;
import dev.xkmc.fruitsdelight.init.data.FDModConfig;
import dev.xkmc.fruitsdelight.init.plants.Durian;
import dev.xkmc.l2harvester.api.HarvestResult;
import dev.xkmc.l2harvester.api.HarvestableBlock;
import java.util.List;
import java.util.Locale;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.AlternativesEntry;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.Tags;
import org.jetbrains.annotations.Nullable;

public class DurianLeavesBlock
extends BaseLeavesBlock
implements HarvestableBlock {
    public static final EnumProperty<Fruit> FRUIT = EnumProperty.m_61587_((String)"fruit", Fruit.class);
    public static final EnumProperty<Leaf> LEAF = EnumProperty.m_61587_((String)"leaf", Leaf.class);
    private static final VoxelShape BID = Block.m_49796_((double)3.0, (double)3.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);

    public DurianLeavesBlock(BlockBehaviour.Properties props) {
        super(props);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return state.m_61143_(LEAF) == Leaf.BARE ? BID : super.m_5940_(state, level, pos, ctx);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return state.m_61143_(LEAF) != Leaf.BARE || level.m_8055_(pos.m_7494_()).m_60713_((Block)this);
    }

    @Override
    protected InteractionResult doClick(Level level, BlockPos pos, BlockState state) {
        if (state.m_61143_(FRUIT) == Fruit.FRUITS) {
            if (level instanceof ServerLevel) {
                ServerLevel sl = (ServerLevel)level;
                this.dropFruit(state, sl, pos);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Nullable
    public HarvestResult getHarvestResult(Level level, BlockState state, BlockPos pos) {
        if (((Boolean)state.m_61143_((Property)f_54419_)).booleanValue()) {
            return null;
        }
        if (state.m_61143_(FRUIT) != Fruit.FRUITS) {
            return null;
        }
        return new HarvestResult((l, p) -> this.postDropFruit(state, (ServerLevel)l, (BlockPos)p), List.of(Durian.FRUIT.asStack()));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{LEAF, FRUIT});
    }

    protected boolean doDropFruit(BlockState state, ServerLevel level, BlockPos pos) {
        BlockState curSt = state;
        BlockPos curPos = pos;
        while (!curSt.m_247087_()) {
            if (!(curSt.m_60734_() instanceof BaseLeavesBlock)) {
                return false;
            }
            curPos = curPos.m_7495_();
            curSt = level.m_8055_(curPos);
        }
        FallingBlockEntity.m_201971_((Level)level, (BlockPos)pos, (BlockState)Durian.FRUIT.getDefaultState());
        return true;
    }

    protected boolean createFlower(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (level.m_151570_(pos.m_7495_())) {
            return false;
        }
        BlockState below = level.m_8055_(pos.m_7495_());
        if (below.m_60795_()) {
            BlockState next = (BlockState)((BlockState)((BlockState)state.m_61124_((Property)f_221367_, (Comparable)Boolean.valueOf(false))).m_61124_(LEAF, (Comparable)((Object)Leaf.BARE))).m_61124_(FRUIT, (Comparable)((Object)Fruit.FLOWERS));
            level.m_46597_(pos.m_7495_(), next);
            return true;
        }
        if (below.m_60713_((Block)this) && below.m_61143_(FRUIT) == Fruit.NONE) {
            level.m_46597_(pos.m_7495_(), (BlockState)below.m_61124_(FRUIT, (Comparable)((Object)Fruit.FLOWERS)));
            return true;
        }
        return false;
    }

    protected void dropFruit(BlockState state, ServerLevel level, BlockPos pos) {
        if (this.doDropFruit(state, level, pos)) {
            this.postDropFruit(state, level, pos);
        }
    }

    protected void postDropFruit(BlockState state, ServerLevel level, BlockPos pos) {
        if (state.m_61143_(LEAF) == Leaf.BARE) {
            level.m_7471_(pos, false);
        } else {
            level.m_46597_(pos, (BlockState)state.m_61124_(FRUIT, (Comparable)((Object)Fruit.NONE)));
        }
    }

    public boolean m_6724_(BlockState state) {
        if (((Boolean)state.m_61143_((Property)f_54419_)).booleanValue()) {
            return false;
        }
        if (state.m_61143_(LEAF) == Leaf.BUDDING) {
            return true;
        }
        if (state.m_61143_(FRUIT) != Fruit.NONE) {
            return true;
        }
        return super.m_6724_(state);
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!((Boolean)state.m_61143_((Property)f_54419_)).booleanValue() && !this.m_221385_(state)) {
            boolean grow;
            Fruit st = (Fruit)((Object)state.m_61143_(FRUIT));
            if (st == Fruit.FLOWERS) {
                boolean bl = grow = random.m_188500_() < (Double)FDModConfig.COMMON.fruitsGrowChance.get();
                if (ForgeHooks.onCropsGrowPre((Level)level, (BlockPos)pos, (BlockState)state, (boolean)grow)) {
                    level.m_46597_(pos, (BlockState)state.m_61124_(FRUIT, (Comparable)((Object)Fruit.SMALL)));
                    ForgeHooks.onCropsGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
                    return;
                }
            }
            if (st == Fruit.SMALL) {
                boolean bl = grow = random.m_188500_() < (Double)FDModConfig.COMMON.fruitsGrowChance.get();
                if (ForgeHooks.onCropsGrowPre((Level)level, (BlockPos)pos, (BlockState)state, (boolean)grow)) {
                    if ((Double)FDModConfig.COMMON.fruitsDropChance.get() < (Double)FDModConfig.COMMON.fruitsGrowChance.get()) {
                        level.m_46597_(pos, (BlockState)state.m_61124_(FRUIT, (Comparable)((Object)Fruit.FRUITS)));
                    } else {
                        this.dropFruit(state, level, pos);
                    }
                    ForgeHooks.onCropsGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
                    return;
                }
            }
            if (st == Fruit.FRUITS && random.m_188500_() < (Double)FDModConfig.COMMON.fruitsDropChance.get()) {
                this.dropFruit(state, level, pos);
                return;
            }
            Leaf leaf = (Leaf)((Object)state.m_61143_(LEAF));
            if (st == Fruit.NONE && leaf == Leaf.BUDDING) {
                boolean grow2;
                boolean bl = grow2 = random.m_188500_() < (Double)FDModConfig.COMMON.fruitsGrowChance.get();
                if (ForgeHooks.onCropsGrowPre((Level)level, (BlockPos)pos, (BlockState)state, (boolean)grow2) && this.createFlower(state, level, pos, random)) {
                    level.m_46597_(pos, (BlockState)state.m_61124_(LEAF, (Comparable)((Object)Leaf.LEAF)));
                    BlockPos next = this.findNextFlowerTarget((Level)level, pos, e -> (Boolean)e.m_61143_((Property)f_54419_) == false && e.m_61143_(LEAF) == Leaf.LEAF);
                    if (next != null) {
                        BlockState ns = level.m_8055_(next);
                        level.m_46597_(next, (BlockState)ns.m_61124_(LEAF, (Comparable)((Object)Leaf.BUDDING)));
                    }
                    return;
                }
            }
        }
        super.m_213898_(state, level, pos, random);
    }

    @Override
    public BlockState flowerState() {
        return (BlockState)this.m_49966_().m_61124_(LEAF, (Comparable)((Object)Leaf.BUDDING));
    }

    @Override
    public void buildLeavesModel(DataGenContext<Block, ? extends BaseLeavesBlock> ctx, RegistrateBlockstateProvider pvd, String name) {
        BlockModelBuilder leaves = (BlockModelBuilder)((BlockModelBuilder)pvd.models().withExistingParent(name + "_leaves", "block/leaves")).texture("all", "block/" + name + "_leaves");
        BlockModelBuilder flowers = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)pvd.models().withExistingParent(name + "_flowers", "block/cross")).texture("cross", "block/" + name + "_flowers")).renderType("cutout");
        BlockModelBuilder small = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)pvd.models().getBuilder(name + "_small")).parent((ModelFile)new ModelFile.UncheckedModelFile(pvd.modLoc("block/durian_small_base")))).texture("top", pvd.modLoc("block/durian_top_small"))).texture("side", pvd.modLoc("block/durian_side_small"))).renderType("cutout");
        BlockModelBuilder fruits = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)pvd.models().getBuilder(name + "_fruits")).parent((ModelFile)new ModelFile.UncheckedModelFile(pvd.modLoc("block/durian_base")))).texture("top", pvd.modLoc("block/durian_top"))).texture("side", pvd.modLoc("block/durian_side"))).renderType("cutout");
        ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)pvd.getMultipartBuilder((Block)ctx.get()).part().modelFile((ModelFile)leaves).addModel()).condition(LEAF, (Comparable[])new Leaf[]{Leaf.LEAF, Leaf.BUDDING}).end().part().modelFile((ModelFile)flowers).addModel()).condition(FRUIT, (Comparable[])new Fruit[]{Fruit.FLOWERS}).end().part().modelFile((ModelFile)small).addModel()).condition(FRUIT, (Comparable[])new Fruit[]{Fruit.SMALL}).end().part().modelFile((ModelFile)fruits).addModel()).condition(FRUIT, (Comparable[])new Fruit[]{Fruit.FRUITS}).end();
    }

    @Override
    public void buildLoot(RegistrateBlockLootTables pvd, Block block, Block sapling, Item fruit) {
        LootPoolSingletonContainer.Builder leaves = (LootPoolSingletonContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)block).m_79080_(LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_(LEAF, (Comparable)((Object)Leaf.BARE))).m_81807_())).m_79080_((LootItemCondition.Builder)MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_45071_(new EnchantmentPredicate(Enchantments.f_44985_, MinMaxBounds.Ints.m_55386_((int)1)))).m_285888_(MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_204145_(Tags.Items.SHEARS))));
        LootPoolSingletonContainer.Builder fruits = (LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)fruit).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_(FRUIT, (Comparable)((Object)Fruit.FRUITS))));
        AlternativesEntry.Builder drops = AlternativesEntry.m_79395_((LootPoolEntryContainer.Builder[])new LootPoolEntryContainer.Builder[]{leaves, fruits});
        pvd.m_247577_(block, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)drops).m_79080_(ExplosionCondition.m_81661_())));
    }

    public static enum Leaf implements StringRepresentable
    {
        LEAF,
        BUDDING,
        BARE;


        public String m_7912_() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }

    public static enum Fruit implements StringRepresentable
    {
        NONE,
        FLOWERS,
        SMALL,
        FRUITS;


        public String m_7912_() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

