/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.fruitsdelight.init.plants;

import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import com.tterrag.registrate.providers.RegistrateRecipeProvider;
import com.tterrag.registrate.providers.loot.RegistrateBlockLootTables;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.entry.ItemEntry;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import dev.xkmc.fruitsdelight.content.block.BaseBushBlock;
import dev.xkmc.fruitsdelight.content.block.PineappleBlock;
import dev.xkmc.fruitsdelight.content.block.WildPineappleBlock;
import dev.xkmc.fruitsdelight.init.FruitsDelight;
import dev.xkmc.fruitsdelight.init.plants.PlantDataEntry;
import java.util.Locale;
import java.util.function.Consumer;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;
import vectorwing.farmersdelight.common.tag.ForgeTags;
import vectorwing.farmersdelight.data.builder.CuttingBoardRecipeBuilder;

public enum FDPineapple implements PlantDataEntry<FDPineapple>
{
    PINEAPPLE(2, 0.3f, true);

    private final BlockEntry<PineappleBlock> PLANT;
    private final BlockEntry<WildPineappleBlock> WILD;
    private final ItemEntry<Item> fruit;
    private final ItemEntry<Item> slice;
    private final ItemEntry<ItemNameBlockItem> seed;
    public final ResourceKey<ConfiguredFeature<?, ?>> configKey;
    public final ResourceKey<PlacedFeature> placementKey;

    private FDPineapple(int food, float sat, boolean fast) {
        String name = this.name().toLowerCase(Locale.ROOT);
        this.configKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)new ResourceLocation("fruitsdelight", name));
        this.placementKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256988_, (ResourceLocation)new ResourceLocation("fruitsdelight", name));
        this.PLANT = FruitsDelight.REGISTRATE.block(name, p -> new PineappleBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50092_))).blockstate(this::buildPlantModel).loot(this::buildPlantLoot).register();
        this.WILD = ((BlockBuilder)FruitsDelight.REGISTRATE.block("wild_" + name, p -> new WildPineappleBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50034_))).blockstate(this::buildWildModel).loot(this::buildWildLoot).item().model((ctx, pvd) -> pvd.generated((NonNullSupplier)ctx, new ResourceLocation[]{pvd.modLoc("block/" + name + "_wild")})).build()).register();
        this.fruit = ((ItemBuilder)FruitsDelight.REGISTRATE.item(name, Item::new).transform(b -> PlantDataEntry.addFruitTags(name, b))).register();
        this.slice = FruitsDelight.REGISTRATE.item(name + "_slice", p -> new Item(p.m_41489_(FDPineapple.food(food, sat, fast)))).register();
        this.seed = FruitsDelight.REGISTRATE.item(name + "_sapling", p -> new ItemNameBlockItem((Block)this.getPlant(), p)).register();
    }

    private void buildPlantModel(DataGenContext<Block, PineappleBlock> ctx, RegistrateBlockstateProvider pvd) {
        pvd.getVariantBuilder((Block)ctx.get()).forAllStates(state -> {
            int age = (Integer)state.m_61143_((Property)PineappleBlock.AGE);
            String tex = this.getName() + "_stage_" + age;
            return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)pvd.models().cross(tex, pvd.modLoc("block/" + tex))).renderType("cutout")).build();
        });
    }

    private void buildWildModel(DataGenContext<Block, WildPineappleBlock> ctx, RegistrateBlockstateProvider pvd) {
        String tex = this.getName() + "_wild";
        pvd.simpleBlock((Block)ctx.get(), (ModelFile)((BlockModelBuilder)pvd.models().cross(tex, pvd.modLoc("block/" + tex))).renderType("cutout"));
    }

    private void buildPlantLoot(RegistrateBlockLootTables pvd, PineappleBlock block) {
        pvd.m_247577_((Block)block, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)this.getWholeFruit()).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)PineappleBlock.AGE, 4)))).m_7170_((LootPoolEntryContainer.Builder)pvd.m_246108_((ItemLike)block, (FunctionUserBuilder)LootItem.m_79579_((ItemLike)this.getSapling()))))));
    }

    private void buildWildLoot(RegistrateBlockLootTables pvd, WildPineappleBlock block) {
        pvd.m_247577_((Block)block, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)block.m_5456_()).m_79080_(MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_45071_(new EnchantmentPredicate(Enchantments.f_44985_, MinMaxBounds.Ints.m_55386_((int)1)))))).m_7170_((LootPoolEntryContainer.Builder)pvd.m_246108_((ItemLike)block, (FunctionUserBuilder)LootItem.m_79579_((ItemLike)this.getWholeFruit()))))));
    }

    @Override
    public void genRecipe(RegistrateRecipeProvider pvd) {
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{this.getWholeFruit()}), (Ingredient)Ingredient.m_204132_((TagKey)ForgeTags.TOOLS_KNIVES), (ItemLike)this.getSlice(), (int)6, (int)1).addResult((ItemLike)this.getSapling()).addResultWithChance((ItemLike)this.getSapling(), 0.5f).build((Consumer)pvd, new ResourceLocation("fruitsdelight", this.getName() + "_cutting"));
    }

    public BaseBushBlock getPlant() {
        return (BaseBushBlock)((Object)this.PLANT.get());
    }

    public Block getWildPlant() {
        return (Block)this.WILD.get();
    }

    public Item getWholeFruit() {
        return (Item)this.fruit.get();
    }

    public Item getSlice() {
        return (Item)this.slice.get();
    }

    public Item getSapling() {
        return (Item)this.seed.get();
    }

    @Override
    public void registerComposter() {
        ComposterBlock.f_51914_.put((Object)this.getSapling(), 0.3f);
        ComposterBlock.f_51914_.put((Object)this.getSlice(), 0.5f);
        ComposterBlock.f_51914_.put((Object)this.getWholeFruit(), 0.65f);
        ComposterBlock.f_51914_.put((Object)this.getWildPlant().m_5456_(), 0.65f);
    }

    @Override
    public void registerConfigs(BootstapContext<ConfiguredFeature<?, ?>> ctx) {
        FeatureUtils.m_254977_(ctx, this.configKey, (Feature)Feature.f_65763_, (FeatureConfiguration)new RandomPatchConfiguration(24, 5, 3, PlacementUtils.m_206498_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)this.getWildPlant())), (BlockPredicate)BlockPredicate.m_190417_((BlockPredicate[])new BlockPredicate[]{BlockPredicate.m_190419_(), BlockPredicate.m_246848_(), BlockPredicate.m_224774_((Vec3i)Direction.DOWN.m_122436_(), (Block[])new Block[]{Blocks.f_49992_})}))));
    }

    @Override
    public void registerPlacements(BootstapContext<PlacedFeature> ctx) {
        PlacementUtils.m_255206_(ctx, this.placementKey, (Holder)ctx.m_255420_(Registries.f_256911_).m_255043_(this.configKey), (PlacementModifier[])new PlacementModifier[]{RarityFilter.m_191900_((int)32), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
    }

    @Override
    public String getName() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    @Override
    public ResourceKey<PlacedFeature> getPlacementKey() {
        return this.placementKey;
    }

    private static FoodProperties food(int food, float sat, boolean fast) {
        FoodProperties.Builder ans = new FoodProperties.Builder().m_38760_(food).m_38758_(sat);
        if (fast) {
            ans.m_38766_();
        }
        return ans.m_38767_();
    }

    public static void register() {
    }
}

