/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.handlers;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import team.lodestar.lodestone.systems.rendering.ghost.GhostBlockOptions;
import team.lodestar.lodestone.systems.rendering.ghost.GhostBlockRenderer;

public class GhostBlockHandler {
    public static final Map<Object, GhostBlockEntry> GHOSTS = new HashMap<Object, GhostBlockEntry>();

    public static GhostBlockEntry addGhost(Object slot, GhostBlockRenderer renderer, GhostBlockOptions options, int timeLeft) {
        if (!GHOSTS.containsKey(slot)) {
            GHOSTS.put(slot, new GhostBlockEntry(renderer, options, timeLeft));
        }
        GhostBlockEntry ghostBlockEntry = GHOSTS.get(slot);
        ghostBlockEntry.timeLeft = timeLeft;
        ghostBlockEntry.options = options;
        ghostBlockEntry.ghost = renderer;
        return ghostBlockEntry;
    }

    public static void renderGhosts(PoseStack poseStack) {
        GHOSTS.forEach((slot, ghostBlockEntry) -> {
            GhostBlockRenderer ghost = ghostBlockEntry.ghost;
            ghost.render(poseStack, ghostBlockEntry.options);
        });
    }

    public static void tickGhosts() {
        Iterator<Map.Entry<Object, GhostBlockEntry>> iterator = GHOSTS.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, GhostBlockEntry> next = iterator.next();
            GhostBlockEntry entry = next.getValue();
            if (entry.timeLeft <= 0) {
                iterator.remove();
                continue;
            }
            --entry.timeLeft;
        }
    }

    static class GhostBlockEntry {
        private GhostBlockRenderer ghost;
        private GhostBlockOptions options;
        private int timeLeft;

        public GhostBlockEntry(GhostBlockRenderer ghost, GhostBlockOptions options, int timeLeft) {
            this.ghost = ghost;
            this.options = options;
            this.timeLeft = timeLeft;
        }
    }
}

