/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.particle.world.behaviors;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.world.LodestoneWorldParticle;
import team.lodestar.lodestone.systems.particle.world.behaviors.LodestoneParticleBehavior;
import team.lodestar.lodestone.systems.particle.world.behaviors.components.LodestoneBehaviorComponent;
import team.lodestar.lodestone.systems.particle.world.behaviors.components.SparkBehaviorComponent;
import team.lodestar.lodestone.systems.rendering.VFXBuilders;

public class SparkParticleBehavior
implements LodestoneParticleBehavior {
    private static final VFXBuilders.WorldVFXBuilder SPARK_BUILDER = VFXBuilders.createWorld().setFormat(DefaultVertexFormat.f_85813_);

    protected SparkParticleBehavior() {
    }

    @Override
    public SparkBehaviorComponent getComponent(LodestoneBehaviorComponent component) {
        SparkBehaviorComponent spark;
        return component instanceof SparkBehaviorComponent ? (spark = (SparkBehaviorComponent)component) : LodestoneBehaviorComponent.SPARK;
    }

    @Override
    public void render(LodestoneWorldParticle particle, VertexConsumer consumer, Camera camera, float partialTicks) {
        Vec3 vec3 = camera.m_90583_();
        float x = (float)(Mth.m_14139_((double)partialTicks, (double)particle.getXOld(), (double)particle.getX()) - vec3.m_7096_());
        float y = (float)(Mth.m_14139_((double)partialTicks, (double)particle.getYOld(), (double)particle.getY()) - vec3.m_7098_());
        float z = (float)(Mth.m_14139_((double)partialTicks, (double)particle.getZOld(), (double)particle.getZ()) - vec3.m_7094_());
        Vec3 pos = new Vec3((double)x, (double)y, (double)z);
        SparkBehaviorComponent component = this.getComponent(particle.behaviorComponent);
        GenericParticleData lengthData = component.getLengthData(particle);
        float length = lengthData.getValue(particle.getAge(), particle.m_107273_());
        Vec3 offset = component.getDirection(particle).m_82490_((double)length);
        Vec3 movingFrom = component.sparkStart(pos, offset);
        Vec3 movingTo = component.sparkEnd(pos, offset);
        SPARK_BUILDER.setVertexConsumer(consumer).setUV(particle.m_5970_(), particle.m_5951_(), particle.m_5952_(), particle.m_5950_()).setColorRaw(particle.getRed(), particle.getGreen(), particle.getBlue()).setAlpha(particle.getAlpha()).renderBeam(null, movingFrom, movingTo, particle.m_5902_(partialTicks), Vec3.f_82478_);
    }
}

