/*
 * Decompiled with CFR 0.152.
 */
package com.github.eterdelta.crittersandcompanions.network;

import com.github.eterdelta.crittersandcompanions.extension.ISilkLeashState;
import com.github.eterdelta.crittersandcompanions.network.IPacketHandler;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public record ClientboundSilkLeashStatePacket(List<LeashData> leashDataList) {
    public ClientboundSilkLeashStatePacket(LeashData ... leashData) {
        this(Arrays.asList(leashData));
    }

    public static class Handler
    implements IPacketHandler<ClientboundSilkLeashStatePacket> {
        @Override
        public ClientboundSilkLeashStatePacket read(FriendlyByteBuf byteBuf) {
            int size = byteBuf.readInt();
            ArrayList<LeashData> leashDataList = new ArrayList<LeashData>(size);
            for (int i = 0; i < size; ++i) {
                int leashOwner = byteBuf.readInt();
                IntList leashingEntities = byteBuf.m_178338_();
                IntList leashedByEntities = byteBuf.m_178338_();
                leashDataList.add(new LeashData(leashOwner, leashingEntities, leashedByEntities));
            }
            return new ClientboundSilkLeashStatePacket(leashDataList);
        }

        @Override
        public void write(ClientboundSilkLeashStatePacket packet, FriendlyByteBuf byteBuf) {
            byteBuf.writeInt(packet.leashDataList.size());
            for (LeashData data : packet.leashDataList) {
                byteBuf.writeInt(data.leashOwner);
                byteBuf.m_178345_(data.leashingEntities);
                byteBuf.m_178345_(data.leashedByEntities);
            }
        }

        @Override
        public void handle(ClientboundSilkLeashStatePacket packet) {
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            for (LeashData data : packet.leashDataList) {
                Entity entity = level.m_6815_(data.leashOwner());
                if (!(entity instanceof ISilkLeashState)) continue;
                ISilkLeashState leashState = (ISilkLeashState)entity;
                leashState.getLeashingEntities().clear();
                leashState.getLeashedByEntities().clear();
                data.leashingEntities().forEach(id -> {
                    Entity leashingEntity = level.m_6815_(id);
                    if (leashingEntity instanceof LivingEntity) {
                        leashState.getLeashingEntities().add((LivingEntity)leashingEntity);
                    }
                });
                data.leashedByEntities().forEach(id -> {
                    Entity leashedByEntity = level.m_6815_(id);
                    if (leashedByEntity instanceof LivingEntity) {
                        leashState.getLeashedByEntities().add((LivingEntity)leashedByEntity);
                    }
                });
            }
        }
    }

    public record LeashData(int leashOwner, IntList leashingEntities, IntList leashedByEntities) {
    }
}

