/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.content.diesel_engine.modular;

import com.jesz.createdieselgenerators.CDGBlocks;
import com.jesz.createdieselgenerators.CDGConfig;
import com.jesz.createdieselgenerators.content.diesel_engine.EngineSoundInstance;
import com.jesz.createdieselgenerators.content.diesel_engine.EngineUpgrades;
import com.jesz.createdieselgenerators.content.diesel_engine.IEngine;
import com.jesz.createdieselgenerators.content.diesel_engine.modular.ModularDieselEngineBlock;
import com.jesz.createdieselgenerators.content.diesel_engine.modular.ModularDieselEngineValueBox;
import com.jesz.createdieselgenerators.content.diesel_engine.normal.DieselEngineBlock;
import com.simibubi.create.api.connectivity.ConnectivityHandler;
import com.simibubi.create.content.contraptions.bearing.WindmillBearingBlockEntity;
import com.simibubi.create.content.kinetics.base.GeneratingKineticBlockEntity;
import com.simibubi.create.foundation.blockEntity.IMultiBlockEntityContainer;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollOptionBehaviour;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.fml.DistExecutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModularDieselEngineBlockEntity
extends GeneratingKineticBlockEntity
implements IEngine,
IMultiBlockEntityContainer.Fluid {
    protected ScrollOptionBehaviour<WindmillBearingBlockEntity.RotationDirection> movementDirection;
    protected float remainingTicks = 0.0f;
    protected int length = 1;
    @NotNull
    protected EngineUpgrades upgrade = EngineUpgrades.EMPTY;
    protected LazyOptional<IFluidHandler> fluidCapability = LazyOptional.empty();
    protected FluidTank tankInventory = new SmartFluidTank(1000, f -> this.sendData());
    protected BlockPos controller;
    protected BlockPos lastKnownPos;
    protected boolean updateConnectivity = false;
    protected boolean updateCapability = false;
    @OnlyIn(value=Dist.CLIENT)
    protected EngineSoundInstance soundInstance;

    public ModularDieselEngineBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.movementDirection = new ScrollOptionBehaviour(WindmillBearingBlockEntity.RotationDirection.class, (Component)CreateLang.translateDirect((String)"contraptions.windmill.rotation_direction", (Object[])new Object[0]), (SmartBlockEntity)this, (ValueBoxTransform)new ModularDieselEngineValueBox());
        this.movementDirection.withCallback(this::onDirectionChanged);
        behaviours.add((BlockEntityBehaviour)this.movementDirection);
        super.addBehaviours(behaviours);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap != ForgeCapabilities.FLUID_HANDLER) {
            return super.getCapability(cap, side);
        }
        if (!this.fluidCapability.isPresent()) {
            this.refreshCapability();
        }
        if (side == null || side == Direction.UP && ((Boolean)this.m_58900_().m_61143_((Property)ModularDieselEngineBlock.PIPE)).booleanValue()) {
            return this.fluidCapability.cast();
        }
        return super.getCapability(cap, side);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        if (this.isController()) {
            if (this.getGeneratedSpeed() == 0.0f) {
                return false;
            }
            super.addToGoggleTooltip(tooltip, isPlayerSneaking);
            this.containedFluidTooltip(tooltip, isPlayerSneaking, this.fluidCapability.cast());
            return true;
        }
        ModularDieselEngineBlockEntity controller = this.getControllerBE();
        if (controller == null) {
            return false;
        }
        return controller.addToGoggleTooltip(tooltip, isPlayerSneaking);
    }

    public void onDirectionChanged(int v) {
        ModularDieselEngineBlockEntity controller = this.getControllerBE();
        if (controller != null) {
            controller.movementDirection.setValue(v);
            controller.reActivateSource = true;
            for (int i = 0; i < controller.getHeight(); ++i) {
                BlockEntity blockEntity = this.f_58857_.m_7702_(controller.m_58899_().m_5487_(((Direction)controller.m_58900_().m_61143_((Property)ModularDieselEngineBlock.FACING)).m_122434_(), i));
                if (!(blockEntity instanceof ModularDieselEngineBlockEntity)) continue;
                ModularDieselEngineBlockEntity be = (ModularDieselEngineBlockEntity)blockEntity;
                if (be.movementDirection.getValue() == v) continue;
                be.movementDirection.setValue(v);
            }
        }
    }

    public float calculateAddedStressCapacity() {
        float capacity;
        this.lastCapacityProvided = capacity = this.upgrade.getCapacity(this.getFuelCapacity() * (float)this.getHeight() * (1.0f / this.upgrade.getSpeed(this.getFuelSpeed(), this)) * this.getFuelSpeed(), this);
        return capacity;
    }

    public float getGeneratedSpeed() {
        if (!this.enabled() || !this.isController() || this.remainingTicks < 1.0f) {
            return 0.0f;
        }
        return ModularDieselEngineBlockEntity.convertToDirection((float)((float)(this.movementDirection.getValue() == 1 ? -1 : 1) * this.upgrade.getSpeed(this.getFuelSpeed(), this)), (Direction)((Direction)this.m_58900_().m_61143_((Property)ModularDieselEngineBlock.FACING)));
    }

    public void tick() {
        super.tick();
        if (this.updateCapability) {
            this.updateCapability = false;
            this.refreshCapability();
        }
        if (this.updateConnectivity) {
            this.updateConnectivity();
        }
        if (!this.isController()) {
            if (this.upgrade == EngineUpgrades.EMPTY) {
                return;
            }
            ModularDieselEngineBlockEntity controller = this.getControllerBE();
            if (controller.upgrade == EngineUpgrades.EMPTY) {
                controller.upgrade = this.upgrade;
            } else {
                Block.m_49840_((Level)this.f_58857_, (BlockPos)this.m_58899_(), (ItemStack)this.upgrade.getItem());
            }
            this.upgrade = EngineUpgrades.EMPTY;
            return;
        }
        this.reActivateSource = true;
        if (this.enabled()) {
            if (this.remainingTicks < (float)(this.length + 1)) {
                this.remainingTicks += (float)this.length / this.getFuelBurnRate();
                this.tankInventory.drain(this.length, IFluidHandler.FluidAction.EXECUTE);
            }
            if (this.remainingTicks >= 0.0f) {
                this.remainingTicks -= (float)this.length;
            }
        }
        if (this.f_58857_.f_46443_) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> this::tickClient);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void tickClient() {
        if (this.enabled()) {
            Vec3 pos = Vec3.m_82512_((Vec3i)this.m_58899_());
            pos = ((Direction)this.m_58900_().m_61143_((Property)ModularDieselEngineBlock.FACING)).m_122434_() == Direction.Axis.X ? pos.m_82520_((double)this.length / 2.0 - 0.5, 0.0, 0.0) : pos.m_82520_(0.0, 0.0, (double)this.length / 2.0 - 0.5);
            if (this.soundInstance == null || this.soundInstance.m_7801_() || this.soundInstance.m_7772_() != pos.f_82479_ || this.soundInstance.m_7778_() != pos.f_82481_) {
                this.soundInstance = this.upgrade.createSoundInstance(this, pos);
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)this.soundInstance);
            } else if (this.soundInstance.active()) {
                this.soundInstance.keepAlive();
                this.soundInstance.setPitch(this.upgrade.getPitchMultiplier(this) * this.getFuelSoundPitch());
                this.soundInstance.setVolume(this.upgrade.getVolume(this));
            }
        } else if (this.soundInstance != null) {
            this.soundInstance.fadeOut();
            this.soundInstance = null;
        }
    }

    void refreshCapability() {
        LazyOptional<IFluidHandler> oldCap = this.fluidCapability;
        this.fluidCapability = LazyOptional.of(this::handlerForCapability);
        oldCap.invalidate();
    }

    private IFluidHandler handlerForCapability() {
        return this.isController() ? this.tankInventory : (this.getControllerBE() != null ? this.getControllerBE().handlerForCapability() : new FluidTank(0));
    }

    public void updateConnectivity() {
        this.updateConnectivity = false;
        if (this.f_58857_.f_46443_) {
            return;
        }
        if (!this.isController()) {
            return;
        }
        ConnectivityHandler.formMulti((BlockEntity)this);
    }

    @Override
    public float getRemainingTicks() {
        return this.remainingTicks;
    }

    @Override
    public SmartBlockEntity self() {
        return this;
    }

    @Override
    public FluidTank getTank() {
        return this.tankInventory;
    }

    @Override
    public EngineUpgrades getUpgrade() {
        return this.upgrade;
    }

    @Override
    public void setUpgrade(EngineUpgrades upgrade) {
        this.upgrade = upgrade;
    }

    public BlockPos getController() {
        return this.isController() ? this.f_58858_ : this.controller;
    }

    public ModularDieselEngineBlockEntity getControllerBE() {
        if (this.isController() || !this.m_58898_()) {
            return this;
        }
        BlockEntity be = this.f_58857_.m_7702_(this.controller);
        if (be instanceof ModularDieselEngineBlockEntity) {
            return (ModularDieselEngineBlockEntity)be;
        }
        return null;
    }

    public boolean isController() {
        return this.controller == null || this.controller.equals((Object)this.f_58858_);
    }

    public void setController(BlockPos controller) {
        if (this.f_58857_.f_46443_ && !this.isVirtual()) {
            return;
        }
        if (controller.equals((Object)this.controller)) {
            return;
        }
        this.controller = controller;
        this.refreshCapability();
        this.m_6596_();
        this.sendData();
    }

    public void removeController(boolean keepContents) {
        if (this.f_58857_.f_46443_) {
            return;
        }
        this.updateConnectivity = true;
        this.controller = null;
        this.length = 1;
        this.reActivateSource = true;
        this.refreshCapability();
        this.m_6596_();
        this.sendData();
    }

    protected void read(CompoundTag tag, boolean clientPacket) {
        boolean changeOfController;
        super.read(tag, clientPacket);
        BlockPos controllerBefore = this.controller;
        int prevHeight = this.length;
        this.updateConnectivity = tag.m_128441_("Uninitialized");
        this.upgrade = EngineUpgrades.get(new ResourceLocation(tag.m_128461_("Upgrade")));
        this.remainingTicks = tag.m_128457_("remainingTicks");
        this.controller = null;
        this.lastKnownPos = null;
        if (tag.m_128441_("LastKnownPos")) {
            this.lastKnownPos = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("LastKnownPos"));
        }
        if (tag.m_128441_("Controller")) {
            this.controller = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("Controller"));
        }
        if (this.isController()) {
            this.length = tag.m_128451_("Height");
            this.tankInventory.readFromNBT(tag.m_128469_("TankContent"));
            if (this.tankInventory.getSpace() < 0) {
                this.tankInventory.drain(-this.tankInventory.getSpace(), IFluidHandler.FluidAction.EXECUTE);
            }
        }
        this.updateCapability = true;
        if (!clientPacket) {
            return;
        }
        boolean bl = changeOfController = !Objects.equals(controllerBefore, this.controller);
        if (changeOfController || prevHeight != this.length) {
            if (this.m_58898_()) {
                this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 16);
            }
            if (this.isController()) {
                this.tankInventory.setCapacity(1000);
            }
            this.invalidateRenderBoundingBox();
        }
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        if (this.updateConnectivity) {
            compound.m_128379_("Uninitialized", true);
        }
        if (this.lastKnownPos != null) {
            compound.m_128365_("LastKnownPos", (Tag)NbtUtils.m_129224_((BlockPos)this.lastKnownPos));
        }
        if (!this.isController()) {
            compound.m_128365_("Controller", (Tag)NbtUtils.m_129224_((BlockPos)this.controller));
        }
        if (this.isController()) {
            compound.m_128359_("Upgrade", this.upgrade.getId().toString());
            compound.m_128350_("remainingTicks", this.remainingTicks);
            compound.m_128365_("TankContent", (Tag)this.tankInventory.writeToNBT(new CompoundTag()));
            compound.m_128405_("Height", this.length);
        }
    }

    public BlockPos getLastKnownPos() {
        return this.lastKnownPos;
    }

    public void preventConnectivityUpdate() {
        this.updateConnectivity = false;
    }

    public void notifyMultiUpdated() {
        this.reActivateSource = true;
        this.m_6596_();
    }

    public Direction.Axis getMainConnectionAxis() {
        return ((Direction)this.m_58900_().m_61143_((Property)ModularDieselEngineBlock.FACING)).m_122434_();
    }

    public int getMaxLength(Direction.Axis longAxis, int width) {
        return 21;
    }

    public int getMaxWidth() {
        return 1;
    }

    public int getHeight() {
        return this.length;
    }

    public void setHeight(int height) {
        this.length = height;
    }

    public int getWidth() {
        return 1;
    }

    public void setWidth(int width) {
    }

    @Override
    public boolean enabled() {
        if (!IEngine.super.enabled()) {
            return false;
        }
        if (!((Boolean)CDGConfig.ENGINES_DISABLED_WITH_REDSTONE.get()).booleanValue()) {
            return true;
        }
        for (int i = 1; i < this.length; ++i) {
            BlockState state = this.f_58857_.m_8055_(this.m_58899_().m_5487_(this.getMainConnectionAxis(), i));
            if (!CDGBlocks.MODULAR_DIESEL_ENGINE.has(state) || !((Boolean)state.m_61143_((Property)DieselEngineBlock.POWERED)).booleanValue()) continue;
            return false;
        }
        return true;
    }
}

