/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.client.gui.controls;

import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.client.gui.GuiGraphics;
import net.montoyo.wd.client.gui.controls.BasicControl;
import net.montoyo.wd.client.gui.controls.Control;
import net.montoyo.wd.client.gui.loading.GuiLoader;
import net.montoyo.wd.client.gui.loading.JsonAWrapper;
import net.montoyo.wd.client.gui.loading.JsonOWrapper;

public abstract class Container
extends BasicControl {
    protected int paddingX = 0;
    protected int paddingY = 0;
    protected final ArrayList<Control> childs = new ArrayList();

    public <T extends Control> T addControl(T ctrl) {
        this.childs.add(ctrl);
        return ctrl;
    }

    @Override
    public boolean keyTyped(int keyCode, int modifiers) {
        boolean typed = false;
        if (!this.disabled) {
            for (Control ctrl : this.childs) {
                typed = typed || ctrl.keyTyped(keyCode, modifiers);
            }
        }
        return typed;
    }

    @Override
    public boolean keyUp(int key, int scanCode, int modifiers) {
        boolean up = false;
        if (!this.disabled) {
            for (Control ctrl : this.childs) {
                up = up || ctrl.keyUp(key, scanCode, modifiers);
            }
        }
        return up;
    }

    @Override
    public boolean keyDown(int key, int scanCode, int modifiers) {
        boolean down = false;
        if (!this.disabled) {
            for (Control ctrl : this.childs) {
                down = down || ctrl.keyDown(key, scanCode, modifiers);
            }
        }
        return down;
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        boolean clicked;
        block1: {
            Control ctrl;
            clicked = false;
            if (this.disabled) break block1;
            mouseX -= (double)(this.x + this.paddingX);
            mouseY -= (double)(this.y + this.paddingY);
            Iterator<Control> iterator = this.childs.iterator();
            while (iterator.hasNext() && !(clicked = (ctrl = iterator.next()).mouseClicked(mouseX, mouseY, mouseButton))) {
            }
        }
        return clicked;
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int state) {
        boolean released = false;
        if (!this.disabled) {
            mouseX -= (double)(this.x + this.paddingX);
            mouseY -= (double)(this.y + this.paddingY);
            for (Control ctrl : this.childs) {
                released = released || ctrl.mouseReleased(mouseX, mouseY, state);
            }
        }
        return released;
    }

    @Override
    public boolean mouseClickMove(double mouseX, double mouseY, int button, double dragX, double dragY) {
        boolean clicked = false;
        if (!this.disabled) {
            mouseX -= (double)(this.x + this.paddingX);
            mouseY -= (double)(this.y + this.paddingY);
            for (Control ctrl : this.childs) {
                clicked = clicked || ctrl.mouseClickMove(mouseX, mouseY, button, dragX, dragY);
            }
        }
        return clicked;
    }

    @Override
    public boolean mouseMove(double mouseX, double mouseY) {
        boolean clicked = false;
        if (!this.disabled) {
            mouseX -= (double)(this.x + this.paddingX);
            mouseY -= (double)(this.y + this.paddingY);
            for (Control ctrl : this.childs) {
                clicked = clicked || ctrl.mouseMove(mouseX, mouseY);
            }
        }
        return clicked;
    }

    @Override
    public boolean mouseScroll(double mouseX, double mouseY, double amount) {
        boolean scrolled = false;
        if (!this.disabled) {
            mouseX -= (double)(this.x + this.paddingX);
            mouseY -= (double)(this.y + this.paddingY);
            for (Control ctrl : this.childs) {
                scrolled = scrolled || ctrl.mouseScroll(mouseX, mouseY, amount);
            }
        }
        return scrolled;
    }

    @Override
    public void draw(GuiGraphics poseStack, int mouseX, int mouseY, float ptt) {
        if (this.visible) {
            mouseX -= this.x + this.paddingX;
            mouseY -= this.y + this.paddingY;
            poseStack.m_280168_().m_85836_();
            poseStack.m_280168_().m_85837_((double)(this.x + this.paddingX), (double)(this.y + this.paddingY), 0.0);
            if (this.disabled) {
                for (Control ctrl : this.childs) {
                    ctrl.draw(poseStack, -1, -1, ptt);
                }
            } else {
                for (Control ctrl : this.childs) {
                    ctrl.draw(poseStack, mouseX, mouseY, ptt);
                }
            }
            poseStack.m_280168_().m_85849_();
        }
    }

    @Override
    public void destroy() {
        for (Control ctrl : this.childs) {
            ctrl.destroy();
        }
    }

    @Override
    public void load(JsonOWrapper json) {
        super.load(json);
        JsonAWrapper objs = json.getArray("childs");
        for (int i = 0; i < objs.size(); ++i) {
            this.childs.add(GuiLoader.create(objs.getObject(i)));
        }
    }

    public Control getByName(String name) {
        for (Control ctrl : this.childs) {
            Control ret;
            if (name.equals(ctrl.name)) {
                return ctrl;
            }
            if (!(ctrl instanceof Container) || (ret = ((Container)ctrl).getByName(name)) == null) continue;
            return ret;
        }
        return null;
    }

    @Override
    public void unfocus() {
        for (Control control : this.childs) {
            control.unfocus();
        }
    }
}

