/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.client.renderers;

import com.cinemamod.mcef.MCEFBrowser;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.montoyo.wd.WebDisplays;
import net.montoyo.wd.entity.ScreenBlockEntity;
import net.montoyo.wd.entity.ScreenData;
import net.montoyo.wd.utilities.math.Vector3f;
import net.montoyo.wd.utilities.math.Vector3i;
import org.jetbrains.annotations.NotNull;

public class ScreenRenderer
implements BlockEntityRenderer<ScreenBlockEntity> {
    private final Vector3f mid = new Vector3f();
    private final Vector3i tmpi = new Vector3i();
    private final Vector3f tmpf = new Vector3f();

    public void render(ScreenBlockEntity te, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        if (!te.isLoaded()) {
            return;
        }
        RenderSystem.disableBlend();
        for (int i = 0; i < te.screenCount(); ++i) {
            ScreenData scr = te.getScreen(i);
            if (scr.browser == null) {
                double dist = WebDisplays.PROXY.distanceTo(te, Minecraft.m_91087_().m_91290_().f_114358_.m_90583_());
                if (!(dist <= WebDisplays.INSTANCE.loadDistance2 * 16.0)) continue;
                scr.createBrowser(te, true);
            }
            this.tmpi.set(scr.side.right);
            this.tmpi.mul(scr.size.x);
            this.tmpi.addMul(scr.side.up, scr.size.y);
            this.tmpf.set(this.tmpi);
            this.mid.set(0.5, 0.5, 0.5);
            this.mid.addMul(this.tmpf, 0.5f);
            this.tmpf.set(scr.side.left);
            this.mid.addMul(this.tmpf, 0.5f);
            this.tmpf.set(scr.side.down);
            this.mid.addMul(this.tmpf, 0.5f);
            poseStack.m_85836_();
            poseStack.m_252880_(this.mid.x, this.mid.y, this.mid.z);
            switch (scr.side) {
                case BOTTOM: {
                    poseStack.m_252781_(Axis.f_252529_.m_252961_(139.8f));
                    break;
                }
                case TOP: {
                    poseStack.m_252781_(Axis.f_252495_.m_252961_(139.8f));
                    break;
                }
                case NORTH: {
                    poseStack.m_252781_(Axis.f_252392_.m_252977_(180.0f));
                    break;
                }
                case SOUTH: {
                    break;
                }
                case WEST: {
                    poseStack.m_252781_(Axis.f_252392_.m_252977_(90.0f));
                    break;
                }
                case EAST: {
                    poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
                }
            }
            if (scr.doTurnOnAnim) {
                long lt = System.currentTimeMillis() - scr.turnOnTime;
                float ft = (float)lt / 100.0f;
                if (ft >= 1.0f) {
                    ft = 1.0f;
                    scr.doTurnOnAnim = false;
                }
                poseStack.m_85841_(ft, ft, 1.0f);
            }
            if (!scr.rotation.isNull) {
                poseStack.m_252781_(Axis.f_252403_.m_252977_(scr.rotation.angle));
            }
            float sw = (float)scr.size.x * 0.5f - 0.125f;
            float sh = (float)scr.size.y * 0.5f - 0.125f;
            if (scr.rotation.isVertical) {
                float tmp = sw;
                sw = sh;
                sh = tmp;
            }
            Tesselator tesselator = Tesselator.m_85913_();
            BufferBuilder builder = tesselator.m_85915_();
            RenderSystem.enableDepthTest();
            RenderSystem.setShader(GameRenderer::m_172820_);
            RenderSystem._setShaderTexture((int)0, (int)((MCEFBrowser)scr.browser).getRenderer().getTextureID());
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
            builder.m_252986_(poseStack.m_85850_().m_252922_(), -sw, -sh, 0.505f).m_7421_(0.0f, 1.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_5752_();
            builder.m_252986_(poseStack.m_85850_().m_252922_(), sw, -sh, 0.505f).m_7421_(1.0f, 1.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_5752_();
            builder.m_252986_(poseStack.m_85850_().m_252922_(), sw, sh, 0.505f).m_7421_(1.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_5752_();
            builder.m_252986_(poseStack.m_85850_().m_252922_(), -sw, sh, 0.505f).m_7421_(0.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_5752_();
            tesselator.m_85914_();
            RenderSystem.disableDepthTest();
            poseStack.m_85849_();
        }
    }

    public static class ScreenRendererProvider
    implements BlockEntityRendererProvider<ScreenBlockEntity> {
        @NotNull
        public BlockEntityRenderer<ScreenBlockEntity> m_173570_(@NotNull BlockEntityRendererProvider.Context arg) {
            return new ScreenRenderer();
        }
    }
}

