/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.controls.builtin;

import io.netty.buffer.ByteBuf;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;
import net.montoyo.wd.controls.ScreenControl;
import net.montoyo.wd.core.MissingPermissionException;
import net.montoyo.wd.entity.ScreenBlockEntity;
import net.montoyo.wd.utilities.data.BlockSide;
import net.montoyo.wd.utilities.math.Vector3i;

public class SetURLControl
extends ScreenControl {
    public static final ResourceLocation id = new ResourceLocation("webdisplays:set_url");
    String url;
    Vector3i remoteLocation;

    public SetURLControl(String url, Vector3i remoteLocation) {
        super(id);
        this.url = url;
        this.remoteLocation = remoteLocation;
    }

    public SetURLControl(FriendlyByteBuf buf) {
        super(id);
        this.url = buf.m_130277_();
        if (buf.readBoolean()) {
            this.remoteLocation = new Vector3i((ByteBuf)buf);
        }
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.m_130070_(this.url);
        buf.writeBoolean(this.remoteLocation != null);
        if (this.remoteLocation != null) {
            this.remoteLocation.writeTo((ByteBuf)buf);
        }
    }

    @Override
    public void handleServer(BlockPos pos, BlockSide side, ScreenBlockEntity tes, NetworkEvent.Context ctx, Function<Integer, Boolean> permissionChecker) throws MissingPermissionException {
        this.checkPerms(1, permissionChecker, ctx.getSender());
        try {
            tes.setScreenURL(side, this.url);
        }
        catch (Throwable err) {
            err.printStackTrace();
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void handleClient(BlockPos pos, BlockSide side, ScreenBlockEntity tes, NetworkEvent.Context ctx) {
        try {
            tes.setScreenURL(side, this.url);
        }
        catch (Throwable err) {
            err.printStackTrace();
        }
    }
}

