/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.entity;

import com.cinemamod.mcef.MCEFBrowser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;
import net.montoyo.wd.WebDisplays;
import net.montoyo.wd.block.PeripheralBlock;
import net.montoyo.wd.block.ScreenBlock;
import net.montoyo.wd.client.ClientProxy;
import net.montoyo.wd.config.CommonConfig;
import net.montoyo.wd.controls.builtin.ClickControl;
import net.montoyo.wd.core.DefaultUpgrade;
import net.montoyo.wd.core.IUpgrade;
import net.montoyo.wd.data.ScreenConfigData;
import net.montoyo.wd.entity.ScreenData;
import net.montoyo.wd.miniserv.SyncPlugin;
import net.montoyo.wd.net.WDNetworkRegistry;
import net.montoyo.wd.net.client_bound.S2CMessageAddScreen;
import net.montoyo.wd.net.client_bound.S2CMessageScreenUpdate;
import net.montoyo.wd.registry.BlockRegistry;
import net.montoyo.wd.registry.ItemRegistry;
import net.montoyo.wd.registry.TileRegistry;
import net.montoyo.wd.utilities.Log;
import net.montoyo.wd.utilities.Multiblock;
import net.montoyo.wd.utilities.ScreenIterator;
import net.montoyo.wd.utilities.VideoType;
import net.montoyo.wd.utilities.data.BlockSide;
import net.montoyo.wd.utilities.data.Rotation;
import net.montoyo.wd.utilities.math.MutableAABB;
import net.montoyo.wd.utilities.math.Vector2i;
import net.montoyo.wd.utilities.math.Vector3f;
import net.montoyo.wd.utilities.math.Vector3i;
import net.montoyo.wd.utilities.serialization.NameUUIDPair;
import net.montoyo.wd.utilities.serialization.TypeData;
import org.cef.browser.CefBrowser;

public class ScreenBlockEntity
extends BlockEntity {
    private final ArrayList<ScreenData> screens = new ArrayList();
    private AABB renderBB = new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    private boolean loaded = true;
    public float ytVolume = Float.POSITIVE_INFINITY;

    public ScreenBlockEntity(BlockPos arg2, BlockState arg3) {
        super((BlockEntityType)TileRegistry.SCREEN_BLOCK_ENTITY.get(), arg2, arg3);
    }

    public void forEachScreenBlocks(BlockSide side, Consumer<BlockPos> func) {
        ScreenData scr = this.getScreen(side);
        if (scr != null) {
            ScreenIterator it = new ScreenIterator(this.m_58899_(), side, scr.size);
            while (it.hasNext()) {
                func.accept(it.next());
            }
        }
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void load() {
        this.loaded = true;
    }

    public void unload() {
        for (ScreenData scr : this.screens) {
            if (scr.browser == null) continue;
            scr.browser.close(true);
            scr.browser = null;
        }
        this.screens.clear();
        this.loaded = false;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        ListTag list = tag.m_128437_("WDScreens", 10);
        if (list.isEmpty()) {
            return;
        }
        for (ScreenData screen : this.screens) {
            if (screen.browser == null) continue;
            screen.browser.close(true);
            screen.browser = null;
        }
        this.screens.clear();
        for (int i = 0; i < list.size(); ++i) {
            this.screens.add(ScreenData.deserialize(list.m_128728_(i)));
        }
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
        for (ScreenData screen : this.screens) {
            if (screen.browser == null) {
                screen.createBrowser(this, false);
            }
            if (screen.browser == null) continue;
            screen.browser.loadURL(screen.url);
        }
        this.updateAABB();
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        ListTag list = new ListTag();
        for (ScreenData scr : this.screens) {
            list.add((Object)scr.serialize());
        }
        tag.m_128365_("WDScreens", (Tag)list);
    }

    public ScreenData addScreen(BlockSide side, Vector2i size, @Nullable Vector2i resolution, @Nullable Player owner, boolean sendUpdate) {
        for (ScreenData scr : this.screens) {
            if (scr.side != side) continue;
            return scr;
        }
        ScreenData ret = new ScreenData();
        ret.side = side;
        ret.size = size;
        ret.url = CommonConfig.Browser.homepage;
        ret.friends = new ArrayList();
        ret.friendRights = 51;
        ret.otherRights = 51;
        ret.upgrades = new ArrayList();
        if (owner != null) {
            ret.owner = new NameUUIDPair(owner.m_36316_());
            if (side == BlockSide.TOP || side == BlockSide.BOTTOM) {
                int rot = (int)Math.floor((double)(owner.m_146908_() * 4.0f / 360.0f) + 2.5) & 3;
                if (side == BlockSide.TOP) {
                    if (rot == 1) {
                        rot = 3;
                    } else if (rot == 3) {
                        rot = 1;
                    }
                }
                ret.rotation = Rotation.values()[rot];
            }
        }
        if (resolution == null || resolution.x < 1 || resolution.y < 1) {
            float psx = (float)size.x * 16.0f - 4.0f;
            float psy = (float)size.y * 16.0f - 4.0f;
            ret.resolution = new Vector2i((int)(psx *= 8.0f), (int)(psy *= 8.0f));
        } else {
            ret.resolution = resolution;
        }
        ret.clampResolution();
        if (!this.f_58857_.f_46443_) {
            ret.setupRedstoneStatus(this.f_58857_, this.m_58899_());
            if (sendUpdate) {
                WDNetworkRegistry.INSTANCE.send(PacketDistributor.NEAR.with(() -> PeripheralBlock.point(this.f_58857_, this.m_58899_())), (Object)new S2CMessageAddScreen(this, ret));
            }
        }
        this.screens.add(ret);
        if (this.f_58857_.f_46443_) {
            this.updateAABB();
        } else {
            this.m_6596_();
        }
        return ret;
    }

    public ScreenData getScreen(BlockSide side) {
        for (ScreenData scr : this.screens) {
            if (scr.side != side) continue;
            return scr;
        }
        return null;
    }

    public int screenCount() {
        return this.screens.size();
    }

    public ScreenData getScreen(int idx) {
        return this.screens.get(idx);
    }

    public void clear() {
        for (ScreenData screen : this.screens) {
            if (screen.browser == null) continue;
            screen.browser.close(true);
            screen.browser = null;
        }
        this.screens.clear();
        if (!this.f_58857_.f_46443_) {
            this.m_6596_();
        }
    }

    public static String url(String url) throws IOException {
        Log.info("URL received: " + url, new Object[0]);
        if (!(WebDisplays.PROXY instanceof ClientProxy)) {
            List serverPlayers = WebDisplays.PROXY.getServer().m_6846_().m_11314_();
            SyncPlugin.syncPlayers(serverPlayers);
            for (ServerPlayer serverPlayer : serverPlayers) {
                SyncPlugin.setPlayerString(serverPlayer, url);
            }
            return url;
        }
        return url;
    }

    public void setScreenURL(BlockSide side, String url) throws IOException {
        ScreenData scr = this.getScreen(side);
        if (scr == null) {
            Log.error("Attempt to change URL of non-existing screen on side %s", side.toString());
            return;
        }
        String weburl = ScreenBlockEntity.url(url);
        scr.url = weburl = WebDisplays.applyBlacklist(weburl);
        scr.videoType = VideoType.getTypeFromURL(weburl);
        if (this.f_58857_.f_46443_) {
            if (scr.browser != null) {
                scr.browser.loadURL(weburl);
            }
        } else {
            WDNetworkRegistry.INSTANCE.send(PacketDistributor.NEAR.with(() -> PeripheralBlock.point(this.f_58857_, this.m_58899_())), (Object)S2CMessageScreenUpdate.setURL(this, side, weburl));
            this.m_6596_();
        }
    }

    public void removeScreen(BlockSide side) {
        int idx = -1;
        for (int i = 0; i < this.screens.size(); ++i) {
            if (this.screens.get((int)i).side != side) continue;
            idx = i;
            break;
        }
        if (idx < 0) {
            Log.error("Tried to delete non-existing screen on side %s", side.toString());
            return;
        }
        if (this.f_58857_.f_46443_) {
            if (this.screens.get((int)idx).browser != null) {
                this.screens.get((int)idx).browser.close(true);
                this.screens.get((int)idx).browser = null;
            }
        } else {
            WDNetworkRegistry.INSTANCE.send(PacketDistributor.NEAR.with(() -> PeripheralBlock.point(this.f_58857_, this.m_58899_())), (Object)new S2CMessageScreenUpdate(this.m_58899_(), side));
        }
        this.screens.remove(idx);
        if (!this.f_58857_.f_46443_) {
            if (this.screens.isEmpty()) {
                this.f_58857_.m_46597_(this.m_58899_(), (BlockState)((ScreenBlock)((Object)BlockRegistry.SCREEN_BLOCk.get())).m_49966_().m_61124_((Property)ScreenBlock.hasTE, (Comparable)Boolean.valueOf(false)));
            } else {
                this.m_6596_();
            }
        }
    }

    public void setResolution(BlockSide side, Vector2i res) {
        if (res.x < 1 || res.y < 1) {
            Log.warning("Call to TileEntityScreen.setResolution(%s) with suspicious values X=%d and Y=%d", side.toString(), res.x, res.y);
            return;
        }
        ScreenData scr = this.getScreen(side);
        if (scr == null) {
            Log.error("Tried to change resolution of non-existing screen on side %s", side.toString());
            return;
        }
        scr.resolution = res;
        scr.clampResolution();
        if (this.f_58857_.f_46443_) {
            WebDisplays.PROXY.screenUpdateResolutionInGui(new Vector3i(this.m_58899_()), side, res);
            if (scr.browser != null) {
                scr.browser.close(true);
                scr.browser = null;
            }
        } else {
            WDNetworkRegistry.INSTANCE.send(PacketDistributor.NEAR.with(() -> PeripheralBlock.point(this.f_58857_, this.m_58899_())), (Object)S2CMessageScreenUpdate.setResolution(this, side, res));
            this.m_6596_();
        }
    }

    private static Player getLaserUser(ScreenData scr) {
        if (scr.laserUser != null && (scr.laserUser.m_213877_() || !scr.laserUser.m_21120_(InteractionHand.MAIN_HAND).m_41720_().equals(ItemRegistry.LASER_POINTER.get()))) {
            scr.laserUser = null;
        }
        return scr.laserUser;
    }

    private static void checkLaserUserRights(ScreenData scr) {
        if (scr.laserUser != null && (scr.rightsFor(scr.laserUser) & 2) == 0) {
            scr.laserUser = null;
        }
    }

    public void clearLaserUser(BlockSide side) {
        ScreenData scr = this.getScreen(side);
        if (scr != null) {
            scr.laserUser = null;
        }
    }

    public void click(BlockSide side, Vector2i vec) {
        ScreenData scr = this.getScreen(side);
        if (scr == null) {
            Log.error("Attempt click non-existing screen of side %s", side.toString());
            return;
        }
        if (this.f_58857_.f_46443_) {
            Log.warning("TileEntityScreen.click() from client side is useless...", new Object[0]);
        } else if (ScreenBlockEntity.getLaserUser(scr) == null) {
            WDNetworkRegistry.INSTANCE.send(PacketDistributor.NEAR.with(() -> PeripheralBlock.point(this.f_58857_, this.m_58899_())), (Object)S2CMessageScreenUpdate.click(this, side, ClickControl.ControlType.CLICK, vec));
        }
    }

    public void handleMouseEvent(BlockSide side, ClickControl.ControlType event, @Nullable Vector2i vec, int button) {
        if (button > 1) {
            return;
        }
        ScreenData scr = this.getScreen(side);
        if (scr == null) {
            Log.error("Attempt inject mouse events on non-existing screen of side %s", side.toString());
            return;
        }
        CefBrowser cefBrowser = scr.browser;
        if (cefBrowser instanceof MCEFBrowser) {
            MCEFBrowser mcefBrowser = (MCEFBrowser)cefBrowser;
            if (button == 1) {
                button = 0;
            } else if (button == 0) {
                button = 1;
            }
            if (event == ClickControl.ControlType.CLICK) {
                mcefBrowser.sendMouseMove(vec.x, vec.y);
                mcefBrowser.sendMousePress(vec.x, vec.y, button);
                mcefBrowser.sendMouseRelease(vec.x, vec.y, button);
            } else if (event == ClickControl.ControlType.DOWN) {
                mcefBrowser.sendMouseMove(vec.x, vec.y);
                mcefBrowser.sendMousePress(vec.x, vec.y, button);
            } else if (event == ClickControl.ControlType.MOVE) {
                mcefBrowser.sendMouseMove(vec.x, vec.y);
            } else if (event == ClickControl.ControlType.UP) {
                mcefBrowser.sendMouseRelease(scr.lastMousePos.x, scr.lastMousePos.y, button);
            }
            mcefBrowser.setFocus(true);
            if (vec != null) {
                scr.lastMousePos.x = vec.x;
                scr.lastMousePos.y = vec.y;
            }
        }
    }

    public void onLoad() {
        if (this.f_58857_.f_46443_) {
            WebDisplays.PROXY.trackScreen(this, true);
        }
    }

    public void onChunkUnloaded() {
        if (this.f_58857_.f_46443_) {
            WebDisplays.PROXY.trackScreen(this, false);
            for (ScreenData scr : this.screens) {
                if (scr.browser == null) continue;
                scr.browser.close(true);
                scr.browser = null;
            }
        }
    }

    private void updateAABB() {
        Vector3i origin = new Vector3i(this.m_58899_());
        MutableAABB box = null;
        for (ScreenData scr : this.screens) {
            Vector3i f = scr.side.forward;
            int fx = Math.max(f.x, 0);
            int fy = Math.max(f.y, 0);
            int fz = Math.max(f.z, 0);
            int ox = 0;
            if (scr.side.equals((Object)BlockSide.NORTH)) {
                ox = 1;
            }
            int oz = 0;
            if (scr.side.equals((Object)BlockSide.EAST) || scr.side.equals((Object)BlockSide.TOP) || scr.side.equals((Object)BlockSide.BOTTOM)) {
                oz = 1;
            }
            if (box == null) {
                box = new MutableAABB(origin.x + fx + ox, origin.y + fy, origin.z + fz + oz, origin.x + ox + scr.side.right.x * scr.size.x + fx + scr.side.up.x * scr.size.y, origin.y + scr.side.right.y * scr.size.x + fy + scr.side.up.y * scr.size.y, origin.z + oz + scr.side.right.z * scr.size.x + fz + scr.side.up.z * scr.size.y);
                continue;
            }
            box.expand(origin.x + fx + ox, origin.y + fy, origin.z + fz + oz, origin.x + ox + scr.side.right.x * scr.size.x + fx + scr.side.up.x * scr.size.y, origin.y + scr.side.right.y * scr.size.x + fy + scr.side.up.y * scr.size.y, origin.z + oz + scr.side.right.z * scr.size.x + fz + scr.side.up.z * scr.size.y);
        }
        this.renderBB = box == null ? new AABB(this.f_58858_) : box.toMc();
    }

    @Nonnull
    public AABB getRenderBoundingBox() {
        return this.renderBB;
    }

    public void updateClientSideURL(CefBrowser target, String url) {
        for (ScreenData scr : this.screens) {
            if (scr.browser != target) continue;
            try {
                String webUrl = ScreenBlockEntity.url(url);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            boolean blacklisted = WebDisplays.isSiteBlacklisted(url);
            scr.url = blacklisted ? "mod://webdisplays/blacklisted.html" : url;
            scr.videoType = VideoType.getTypeFromURL(scr.url);
            this.ytVolume = Float.POSITIVE_INFINITY;
            if (!blacklisted || scr.browser == null) break;
            scr.browser.loadURL("mod://webdisplays/blacklisted.html");
            break;
        }
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        if (this.f_58857_.f_46443_) {
            this.onChunkUnloaded();
        }
    }

    public void addFriend(ServerPlayer ply, BlockSide side, NameUUIDPair pair) {
        if (!this.f_58857_.f_46443_) {
            ScreenData scr = this.getScreen(side);
            if (scr == null) {
                Log.error("Tried to add friend to invalid screen side %s", side.toString());
                return;
            }
            if (!scr.friends.contains(pair)) {
                scr.friends.add(pair);
                new ScreenConfigData(new Vector3i(this.m_58899_()), side, scr).updateOnly().sendTo(PeripheralBlock.point(this.f_58857_, this.m_58899_()));
                this.m_6596_();
            }
        }
    }

    public void removeFriend(ServerPlayer ply, BlockSide side, NameUUIDPair pair) {
        if (!this.f_58857_.f_46443_) {
            ScreenData scr = this.getScreen(side);
            if (scr == null) {
                Log.error("Tried to remove friend from invalid screen side %s", side.toString());
                return;
            }
            if (scr.friends.remove(pair)) {
                ScreenBlockEntity.checkLaserUserRights(scr);
                new ScreenConfigData(new Vector3i(this.m_58899_()), side, scr).updateOnly().sendTo(PeripheralBlock.point(this.f_58857_, this.m_58899_()));
                this.m_6596_();
            }
        }
    }

    public void setRights(ServerPlayer ply, BlockSide side, int fr, int or) {
        if (!this.f_58857_.f_46443_) {
            ScreenData scr = this.getScreen(side);
            if (scr == null) {
                Log.error("Tried to change rights of invalid screen on side %s", side.toString());
                return;
            }
            scr.friendRights = fr;
            scr.otherRights = or;
            ScreenBlockEntity.checkLaserUserRights(scr);
            new ScreenConfigData(new Vector3i(this.m_58899_()), side, scr).updateOnly().sendTo(PeripheralBlock.point(this.f_58857_, this.m_58899_()));
            this.m_6596_();
        }
    }

    public void type(BlockSide side, String text, BlockPos soundPos) {
        this.type(side, text, soundPos, null);
    }

    public void type(BlockSide side, String text, BlockPos soundPos, @Nullable ServerPlayer sender) {
        ScreenData scr = this.getScreen(side);
        if (scr == null) {
            Log.error("Tried to type on invalid screen on side %s", side.toString());
            return;
        }
        if (this.f_58857_.f_46443_) {
            CefBrowser cefBrowser = scr.browser;
            if (cefBrowser instanceof MCEFBrowser) {
                MCEFBrowser mcefBrowser = (MCEFBrowser)cefBrowser;
                try {
                    TypeData[] data;
                    if (text.startsWith("t")) {
                        char chr;
                        for (int i = 1; i < text.length() && (chr = text.charAt(i)) != '\u0001'; ++i) {
                            mcefBrowser.sendKeyTyped(chr, 0);
                        }
                    }
                    block8: for (TypeData ev : data = (TypeData[])WebDisplays.GSON.fromJson(text, TypeData[].class)) {
                        if (ev.getKeyCode() == 257) {
                            ev = new TypeData(ev.getAction(), 10, ev.getModifier(), ev.getScanCode());
                        }
                        switch (ev.getAction()) {
                            case PRESS: {
                                mcefBrowser.sendKeyPress(ev.getKeyCode(), (long)ev.getScanCode(), ev.getModifier());
                                if (ev.getKeyCode() != 10) continue block8;
                                mcefBrowser.sendKeyTyped('\r', ev.getModifier());
                                continue block8;
                            }
                            case RELEASE: {
                                mcefBrowser.sendKeyRelease(ev.getKeyCode(), (long)ev.getScanCode(), ev.getModifier());
                                continue block8;
                            }
                            case TYPE: {
                                mcefBrowser.sendKeyTyped((char)ev.getKeyCode(), ev.getModifier());
                                continue block8;
                            }
                            default: {
                                throw new RuntimeException("Invalid type action '" + ev.getAction() + "'");
                            }
                        }
                    }
                }
                catch (Throwable t) {
                    Log.warningEx("Suspicious keyboard type packet received...", t, new Object[0]);
                }
            }
        } else {
            WDNetworkRegistry.INSTANCE.send(PacketDistributor.NEAR.with(sender != null ? () -> PeripheralBlock.point((Player)sender, this.f_58857_, this.m_58899_()) : () -> PeripheralBlock.point(this.f_58857_, this.m_58899_())), (Object)S2CMessageScreenUpdate.type(this, side, text));
            if (soundPos != null) {
                this.playSoundAt(WebDisplays.INSTANCE.soundTyping, soundPos, 0.25f, 1.0f);
            }
        }
    }

    private void playSoundAt(SoundEvent snd, BlockPos at, float vol, float pitch) {
        double x = at.m_123341_();
        double y = at.m_123342_();
        double z = at.m_123343_();
        this.f_58857_.m_6263_(null, x + 0.5, y + 0.5, z + 0.5, snd, SoundSource.BLOCKS, vol, pitch);
    }

    private static String safeName(ItemStack is) {
        return is.m_41720_().m_7626_(is).getString();
    }

    public boolean addUpgrade(BlockSide side, ItemStack is, @Nullable Player player, boolean abortIfExisting) {
        if (this.f_58857_.f_46443_) {
            IUpgrade itemAsUpgrade = (IUpgrade)is.m_41720_();
            ScreenData scr = this.getScreen(side);
            ItemStack isCopy = is.m_41777_();
            scr.upgrades.add(isCopy);
            itemAsUpgrade.onInstall(this, side, player, isCopy);
            return false;
        }
        ScreenData scr = this.getScreen(side);
        if (scr == null) {
            Log.error("Tried to add an upgrade on invalid screen on side %s", side.toString());
            return false;
        }
        if (!(is.m_41720_() instanceof IUpgrade)) {
            Log.error("Tried to add a non-upgrade item %s to screen (%s does not implement IUpgrade)", ScreenBlockEntity.safeName(is), is.m_41720_().getClass().getCanonicalName());
            return false;
        }
        if (scr.upgrades.size() >= 16) {
            Log.error("Can't insert upgrade %s in screen %s at %s: too many upgrades already!", ScreenBlockEntity.safeName(is), side.toString(), this.m_58899_().toString());
            return false;
        }
        IUpgrade itemAsUpgrade = (IUpgrade)is.m_41720_();
        if (abortIfExisting && scr.upgrades.stream().anyMatch(otherStack -> itemAsUpgrade.isSameUpgrade(is, (ItemStack)otherStack))) {
            return false;
        }
        ItemStack isCopy = is.m_41777_();
        isCopy.m_41764_(1);
        scr.upgrades.add(isCopy);
        if (player != null && !player.m_9236_().f_46443_) {
            WDNetworkRegistry.INSTANCE.send(PacketDistributor.NEAR.with(() -> PeripheralBlock.point(this.f_58857_, this.m_58899_())), (Object)S2CMessageScreenUpdate.upgrade(this, side, true, is));
            itemAsUpgrade.onInstall(this, side, player, isCopy);
            this.playSoundAt(WebDisplays.INSTANCE.soundUpgradeAdd, this.m_58899_(), 1.0f, 1.0f);
        }
        this.m_6596_();
        return true;
    }

    public boolean hasUpgrade(BlockSide side, ItemStack is) {
        ScreenData scr = this.getScreen(side);
        if (scr == null) {
            return false;
        }
        if (!(is.m_41720_() instanceof IUpgrade)) {
            return false;
        }
        IUpgrade itemAsUpgrade = (IUpgrade)is.m_41720_();
        return scr.upgrades.stream().anyMatch(otherStack -> itemAsUpgrade.isSameUpgrade(is, (ItemStack)otherStack));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasUpgrade(BlockSide side, DefaultUpgrade du) {
        ScreenData scr = this.getScreen(side);
        if (du == DefaultUpgrade.LASERMOUSE) {
            if (scr == null) return false;
            if (!scr.upgrades.stream().anyMatch(du::matchesLaserMouse)) return false;
            return true;
        }
        if (du == DefaultUpgrade.REDINPUT) {
            if (scr == null) return false;
            if (!scr.upgrades.stream().anyMatch(du::matchesRedInput)) return false;
            return true;
        }
        if (du == DefaultUpgrade.GPS) {
            if (scr == null) return false;
            if (!scr.upgrades.stream().anyMatch(du::matchesGps)) return false;
            return true;
        }
        if (du != DefaultUpgrade.REDOUTPUT) return false;
        if (scr == null) return false;
        if (!scr.upgrades.stream().anyMatch(du::matchesRedOutput)) return false;
        return true;
    }

    public void removeUpgrade(BlockSide side, ItemStack is, @Nullable Player player) {
        if (this.f_58857_.f_46443_) {
            return;
        }
        ScreenData scr = this.getScreen(side);
        if (scr == null) {
            Log.error("Tried to remove an upgrade on invalid screen on side %s", side.toString());
            return;
        }
        if (!(is.m_41720_() instanceof IUpgrade)) {
            Log.error("Tried to remove a non-upgrade item %s to screen (%s does not implement IUpgrade)", ScreenBlockEntity.safeName(is), is.m_41720_().getClass().getCanonicalName());
            return;
        }
        int idxToRemove = -1;
        IUpgrade itemAsUpgrade = (IUpgrade)is.m_41720_();
        for (int i = 0; i < scr.upgrades.size(); ++i) {
            if (!itemAsUpgrade.isSameUpgrade(is, scr.upgrades.get(i))) continue;
            idxToRemove = i;
            break;
        }
        if (idxToRemove >= 0) {
            this.dropUpgrade(scr.upgrades.get(idxToRemove), side, player);
            scr.upgrades.remove(idxToRemove);
            if (player != null && !player.m_9236_().f_46443_) {
                WDNetworkRegistry.INSTANCE.send(PacketDistributor.NEAR.with(() -> PeripheralBlock.point(this.f_58857_, this.m_58899_())), (Object)S2CMessageScreenUpdate.upgrade(this, side, false, is));
                this.playSoundAt(WebDisplays.INSTANCE.soundUpgradeDel, this.m_58899_(), 1.0f, 1.0f);
            }
            this.m_6596_();
        } else {
            Log.warning("Tried to remove non-existing upgrade %s to screen %s at %s", ScreenBlockEntity.safeName(is), side.toString(), this.m_58899_().toString());
        }
    }

    private void dropUpgrade(ItemStack is, BlockSide side, @Nullable Player ply) {
        if (!((IUpgrade)is.m_41720_()).onRemove(this, side, ply, is)) {
            boolean spawnDrop = true;
            if (ply != null && (ply.m_7500_() || ply.m_36356_(is))) {
                spawnDrop = false;
            }
            if (spawnDrop) {
                Vector3f pos = new Vector3f(this.m_58899_().m_123341_(), this.m_58899_().m_123342_(), this.m_58899_().m_123343_());
                pos.addMul(side.backward.toFloat(), 1.5f);
                if (this.f_58857_ != null) {
                    this.f_58857_.m_7967_((Entity)new ItemEntity(this.f_58857_, (double)pos.x, (double)pos.y, (double)pos.z, is));
                }
            }
        }
    }

    private ScreenData getScreenForLaserOp(BlockSide side, Player ply) {
        if (this.f_58857_.f_46443_) {
            return null;
        }
        ScreenData scr = this.getScreen(side);
        if (scr == null) {
            Log.error("Called laser operation on invalid screen on side %s", side.toString());
            return null;
        }
        if ((scr.rightsFor(ply) & 2) == 0) {
            return null;
        }
        if (scr.upgrades.stream().noneMatch(DefaultUpgrade.LASERMOUSE::matchesLaserMouse)) {
            Log.error("Called laser operation on side %s, but it's missing the laser sensor upgrade", side.toString());
            return null;
        }
        return scr;
    }

    public void laserDownMove(BlockSide side, Player ply, Vector2i pos, boolean down, int button) {
        ScreenData scr = this.getScreenForLaserOp(side, ply);
        if (scr != null) {
            if (button == -1) {
                WDNetworkRegistry.INSTANCE.send(PacketDistributor.NEAR.with(() -> PeripheralBlock.point(ply, this.f_58857_, this.m_58899_())), (Object)S2CMessageScreenUpdate.click(this, side, ClickControl.ControlType.MOVE, pos));
            } else if (down) {
                WDNetworkRegistry.INSTANCE.send(PacketDistributor.NEAR.with(() -> PeripheralBlock.point(ply, this.f_58857_, this.m_58899_())), (Object)S2CMessageScreenUpdate.click(this, side, ClickControl.ControlType.DOWN, pos));
            } else {
                WDNetworkRegistry.INSTANCE.send(PacketDistributor.NEAR.with(() -> PeripheralBlock.point(ply, this.f_58857_, this.m_58899_())), (Object)S2CMessageScreenUpdate.click(this, side, ClickControl.ControlType.UP, pos));
            }
        }
    }

    public void laserUp(BlockSide side, Player ply, int button) {
        ScreenData scr = this.getScreenForLaserOp(side, ply);
        if (scr != null && ScreenBlockEntity.getLaserUser(scr) == ply) {
            scr.laserUser = null;
            WDNetworkRegistry.INSTANCE.send(PacketDistributor.NEAR.with(() -> PeripheralBlock.point(ply, this.f_58857_, this.m_58899_())), (Object)S2CMessageScreenUpdate.click(this, side, ClickControl.ControlType.UP, null));
        }
    }

    public void onDestroy(@Nullable Player ply) {
        for (ScreenData scr : this.screens) {
            scr.upgrades.forEach(is -> this.dropUpgrade((ItemStack)is, scr.side, ply));
            scr.upgrades.clear();
        }
        WDNetworkRegistry.INSTANCE.send(PacketDistributor.NEAR.with(() -> PeripheralBlock.point(this.f_58857_, this.m_58899_())), (Object)S2CMessageScreenUpdate.turnOff(this.m_58899_(), null));
    }

    public void disableScreen(BlockSide side) {
        ScreenData remove = null;
        for (ScreenData screen : this.screens) {
            if (screen.side != side) continue;
            remove = screen;
            break;
        }
        if (remove == null) {
            return;
        }
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            ScreenData scrn = remove;
            remove.upgrades.forEach(is -> this.dropUpgrade((ItemStack)is, scrn.side, null));
        }
        remove.upgrades.clear();
        if (remove.browser != null) {
            remove.browser.close(true);
        }
        this.screens.remove(remove);
    }

    public void setOwner(BlockSide side, Player newOwner) {
        if (this.f_58857_.f_46443_) {
            Log.error("Called TileEntityScreen.setOwner() on client...", new Object[0]);
            return;
        }
        if (newOwner == null) {
            Log.error("Called TileEntityScreen.setOwner() with null owner", new Object[0]);
            return;
        }
        ScreenData scr = this.getScreen(side);
        if (scr == null) {
            Log.error("Called TileEntityScreen.setOwner() on invalid screen on side %s", side.toString());
            return;
        }
        scr.owner = new NameUUIDPair(newOwner.m_36316_());
        WDNetworkRegistry.INSTANCE.send(PacketDistributor.NEAR.with(() -> PeripheralBlock.point(this.f_58857_, this.m_58899_())), (Object)S2CMessageScreenUpdate.owner(this, side, scr.owner));
        ScreenBlockEntity.checkLaserUserRights(scr);
        this.m_6596_();
    }

    public void setRotation(BlockSide side, Rotation rot) {
        ScreenData scr = this.getScreen(side);
        if (scr == null) {
            Log.error("Trying to change rotation of invalid screen on side %s", side.toString());
            return;
        }
        if (this.f_58857_.f_46443_) {
            boolean oldWasVertical = scr.rotation.isVertical;
            scr.rotation = rot;
            WebDisplays.PROXY.screenUpdateRotationInGui(new Vector3i(this.m_58899_()), side, rot);
            if (scr.browser != null && oldWasVertical != rot.isVertical) {
                scr.browser.close(true);
                scr.browser = null;
            }
        } else {
            scr.rotation = rot;
            WDNetworkRegistry.INSTANCE.send(PacketDistributor.NEAR.with(() -> PeripheralBlock.point(this.f_58857_, this.m_58899_())), (Object)S2CMessageScreenUpdate.rotation(this, side, rot));
            this.m_6596_();
        }
    }

    public void setAutoVolume(BlockSide side, boolean av) {
        ScreenData scr = this.getScreen(side);
        if (scr == null) {
            Log.error("Trying to toggle auto-volume on invalid screen (side %s)", side.toString());
            return;
        }
        scr.autoVolume = av;
        if (this.f_58857_.f_46443_) {
            WebDisplays.PROXY.screenUpdateAutoVolumeInGui(new Vector3i(this.m_58899_()), side, av);
        } else {
            WDNetworkRegistry.INSTANCE.send(PacketDistributor.NEAR.with(() -> PeripheralBlock.point(this.f_58857_, this.m_58899_())), (Object)S2CMessageScreenUpdate.autoVolume(this, side, av));
            this.m_6596_();
        }
    }

    public void deactivate() {
        for (ScreenData screen : this.screens) {
            if (screen.browser == null) continue;
            screen.browser.close(true);
            screen.browser = null;
        }
    }

    public void activate() {
        for (ScreenData screen : this.screens) {
            if (screen.browser != null) continue;
            screen.createBrowser(this, false);
        }
    }

    public void interact(BlockHitResult result, Consumer<Vector2i> func) {
        BlockState state = this.m_58900_();
        if (state.m_60734_() instanceof ScreenBlock) {
            Vector3i pos = new Vector3i(result.m_82425_());
            BlockSide side = BlockSide.values()[result.m_82434_().ordinal()];
            Multiblock.findOrigin((LevelAccessor)Minecraft.m_91087_().f_91073_, pos, side, null);
            ScreenData scr = this.getScreen(side);
            if (scr.browser != null) {
                float hitX = (float)result.m_82450_().f_82479_ - (float)pos.x;
                float hitY = (float)result.m_82450_().f_82480_ - (float)pos.y;
                float hitZ = (float)result.m_82450_().f_82481_ - (float)pos.z;
                Vector2i tmp = new Vector2i();
                if (ScreenBlock.hit2pixels(side, result.m_82425_(), new Vector3i(result.m_82425_()), scr, hitX, hitY, hitZ, tmp)) {
                    func.accept(tmp);
                }
            }
        }
    }

    public BlockHitResult trace(BlockSide side, Vec3 start, Vec3 look) {
        AABB box = this.getRenderBoundingBox();
        double pHitDistance = box.m_272282_(start) + 2.0;
        Vec3 vec32 = start.m_82520_(look.f_82479_ * pHitDistance, look.f_82480_ * pHitDistance, look.f_82481_ * pHitDistance);
        BlockHitResult bhr = AABB.m_82342_(Arrays.asList(box = box.m_82386_((double)(-this.m_58899_().m_123341_()), (double)(-this.m_58899_().m_123342_()), (double)(-this.m_58899_().m_123343_()))), (Vec3)start, (Vec3)vec32, (BlockPos)this.m_58899_());
        if (!(bhr != null && bhr.m_6662_() == HitResult.Type.BLOCK && bhr.m_82434_().ordinal() == side.ordinal() || (bhr = AABB.m_82342_(Arrays.asList(box), (Vec3)vec32, (Vec3)start, (BlockPos)this.m_58899_())) != null && bhr.m_6662_() == HitResult.Type.BLOCK && bhr.m_82434_().ordinal() == side.ordinal())) {
            return BlockHitResult.m_82426_((Vec3)vec32, (Direction)(bhr == null ? Direction.m_122366_((double)look.f_82479_, (double)look.f_82480_, (double)look.f_82481_).m_122424_() : bhr.m_82434_()), (BlockPos)this.m_58899_());
        }
        return bhr;
    }
}

