/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.entity;

import com.cinemamod.mcef.MCEFBrowser;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.montoyo.wd.WebDisplays;
import net.montoyo.wd.client.ClientProxy;
import net.montoyo.wd.config.CommonConfig;
import net.montoyo.wd.entity.ScreenBlockEntity;
import net.montoyo.wd.utilities.Log;
import net.montoyo.wd.utilities.NibbleArray;
import net.montoyo.wd.utilities.ScreenIterator;
import net.montoyo.wd.utilities.VideoType;
import net.montoyo.wd.utilities.browser.InWorldQueries;
import net.montoyo.wd.utilities.browser.WDBrowser;
import net.montoyo.wd.utilities.data.BlockSide;
import net.montoyo.wd.utilities.data.Rotation;
import net.montoyo.wd.utilities.math.Vector2i;
import net.montoyo.wd.utilities.serialization.NameUUIDPair;
import org.cef.browser.CefBrowser;

public class ScreenData {
    public BlockSide side;
    public Vector2i size;
    public Vector2i resolution;
    public Rotation rotation = Rotation.ROT_0;
    public String url;
    protected VideoType videoType;
    public NameUUIDPair owner;
    public ArrayList<NameUUIDPair> friends;
    public int friendRights;
    public int otherRights;
    public CefBrowser browser;
    public ArrayList<ItemStack> upgrades;
    public boolean doTurnOnAnim;
    public long turnOnTime;
    public Player laserUser;
    public final Vector2i lastMousePos = new Vector2i();
    public NibbleArray redstoneStatus;
    public boolean autoVolume = true;
    public int mouseType;

    public static ScreenData deserialize(CompoundTag tag) {
        ScreenData ret = new ScreenData();
        ret.side = BlockSide.values()[tag.m_128445_("Side")];
        ret.size = new Vector2i(tag.m_128451_("Width"), tag.m_128451_("Height"));
        ret.resolution = new Vector2i(tag.m_128451_("ResolutionX"), tag.m_128451_("ResolutionY"));
        ret.rotation = Rotation.values()[tag.m_128445_("Rotation")];
        ret.url = tag.m_128461_("URL");
        ret.videoType = VideoType.getTypeFromURL(ret.url);
        if (ret.resolution.x <= 0 || ret.resolution.y <= 0) {
            float psx = (float)ret.size.x * 16.0f - 4.0f;
            float psy = (float)ret.size.y * 16.0f - 4.0f;
            ret.resolution.x = (int)(psx *= 8.0f);
            ret.resolution.y = (int)(psy *= 8.0f);
        }
        if (tag.m_128441_("OwnerName")) {
            String name = tag.m_128461_("OwnerName");
            UUID uuid = tag.m_128342_("OwnerUUID");
            ret.owner = new NameUUIDPair(name, uuid);
        }
        ListTag friends = tag.m_128437_("Friends", 10);
        ret.friends = new ArrayList(friends.size());
        for (int i = 0; i < friends.size(); ++i) {
            CompoundTag nf = friends.m_128728_(i);
            NameUUIDPair pair = new NameUUIDPair(nf.m_128461_("Name"), nf.m_128342_("UUID"));
            ret.friends.add(pair);
        }
        ret.friendRights = tag.m_128445_("FriendRights");
        ret.otherRights = tag.m_128445_("OtherRights");
        ListTag upgrades = tag.m_128437_("Upgrades", 10);
        ret.upgrades = new ArrayList();
        for (int i = 0; i < upgrades.size(); ++i) {
            ret.upgrades.add(ItemStack.m_41712_((CompoundTag)upgrades.m_128728_(i)));
        }
        if (tag.m_128441_("AutoVolume")) {
            ret.autoVolume = tag.m_128471_("AutoVolume");
        }
        return ret;
    }

    public CompoundTag serialize() {
        CompoundTag tag = new CompoundTag();
        tag.m_128344_("Side", (byte)this.side.ordinal());
        tag.m_128405_("Width", this.size.x);
        tag.m_128405_("Height", this.size.y);
        tag.m_128405_("ResolutionX", this.resolution.x);
        tag.m_128405_("ResolutionY", this.resolution.y);
        tag.m_128344_("Rotation", (byte)this.rotation.ordinal());
        tag.m_128359_("URL", this.url);
        if (this.owner == null) {
            Log.warning("Found TES with NO OWNER!!", new Object[0]);
        } else {
            tag.m_128359_("OwnerName", this.owner.name);
            tag.m_128362_("OwnerUUID", this.owner.uuid);
        }
        ListTag list = new ListTag();
        for (NameUUIDPair f : this.friends) {
            CompoundTag nf = new CompoundTag();
            nf.m_128359_("Name", f.name);
            nf.m_128362_("UUID", f.uuid);
            list.add((Object)nf);
        }
        tag.m_128365_("Friends", (Tag)list);
        tag.m_128344_("FriendRights", (byte)this.friendRights);
        tag.m_128344_("OtherRights", (byte)this.otherRights);
        list = new ListTag();
        for (ItemStack is : this.upgrades) {
            list.add((Object)is.m_41739_(new CompoundTag()));
        }
        tag.m_128365_("Upgrades", (Tag)list);
        tag.m_128379_("AutoVolume", this.autoVolume);
        return tag;
    }

    public int rightsFor(Player ply) {
        return this.rightsFor(ply.m_36316_().getId());
    }

    public int rightsFor(UUID uuid) {
        if (this.owner.uuid.equals(uuid)) {
            return 255;
        }
        return this.friends.stream().anyMatch(f -> f.uuid.equals(uuid)) ? this.friendRights : this.otherRights;
    }

    public void setupRedstoneStatus(Level world, BlockPos start) {
        if (world.m_5776_()) {
            Log.warning("Called Screen.setupRedstoneStatus() on client.", new Object[0]);
            return;
        }
        if (this.redstoneStatus != null) {
            Log.warning("Called Screen.setupRedstoneStatus() on server, but redstone status is non-null", new Object[0]);
            return;
        }
        Direction[] VALUES = Direction.values();
        this.redstoneStatus = new NibbleArray(this.size.x * this.size.y);
        Direction facing = VALUES[this.side.reverse().ordinal()];
        ScreenIterator it = new ScreenIterator(start, this.side, this.size);
        while (it.hasNext()) {
            int idx = it.getIndex();
            this.redstoneStatus.set(idx, world.m_277185_(it.next(), facing));
        }
    }

    public void clampResolution() {
        if (this.resolution.x > CommonConfig.Screen.maxResolutionX) {
            float newY = (float)this.resolution.y * (float)CommonConfig.Screen.maxResolutionX / (float)this.resolution.x;
            this.resolution.x = CommonConfig.Screen.maxResolutionX;
            this.resolution.y = (int)newY;
        }
        if (this.resolution.y > CommonConfig.Screen.maxResolutionY) {
            float newX = (float)this.resolution.x * (float)CommonConfig.Screen.maxResolutionY / (float)this.resolution.y;
            this.resolution.x = (int)newX;
            this.resolution.y = CommonConfig.Screen.maxResolutionY;
        }
    }

    public void createBrowser(ScreenBlockEntity be, boolean doAnim) {
        if (WebDisplays.PROXY instanceof ClientProxy) {
            this.browser = WDBrowser.createBrowser(WebDisplays.applyBlacklist(this.url != null ? this.url : "https://www.google.com"), false);
            CefBrowser cefBrowser = this.browser;
            if (cefBrowser instanceof MCEFBrowser) {
                MCEFBrowser mcefBrowser = (MCEFBrowser)cefBrowser;
                if (this.rotation.isVertical) {
                    mcefBrowser.resize(this.resolution.y, this.resolution.x);
                } else {
                    mcefBrowser.resize(this.resolution.x, this.resolution.y);
                }
                mcefBrowser.setCursorChangeListener(type -> {
                    this.mouseType = type;
                });
            }
            if ((cefBrowser = this.browser) instanceof WDBrowser) {
                WDBrowser wdBrowser = (WDBrowser)cefBrowser;
                InWorldQueries.attach(be, this.side, wdBrowser);
            }
            this.doTurnOnAnim = doAnim;
            this.turnOnTime = System.currentTimeMillis();
        }
    }
}

