/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.item;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.montoyo.wd.block.ScreenBlock;
import net.montoyo.wd.config.CommonConfig;
import net.montoyo.wd.entity.ScreenBlockEntity;
import net.montoyo.wd.entity.ScreenData;
import net.montoyo.wd.item.WDItem;
import net.montoyo.wd.utilities.Log;
import net.montoyo.wd.utilities.Multiblock;
import net.montoyo.wd.utilities.data.BlockSide;
import net.montoyo.wd.utilities.math.Vector3i;
import net.montoyo.wd.utilities.serialization.Util;
import org.jetbrains.annotations.NotNull;

public class ItemOwnershipThief
extends Item
implements WDItem {
    public ItemOwnershipThief(Item.Properties properties) {
        super(properties.m_41487_(1));
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext context) {
        CompoundTag tag;
        if (context.m_43723_().m_6144_()) {
            return InteractionResult.PASS;
        }
        if (context.m_43725_().f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (CommonConfig.disableOwnershipThief) {
            Util.toast(context.m_43723_(), "otDisabled", new Object[0]);
            return InteractionResult.SUCCESS;
        }
        ItemStack stack = context.m_43723_().m_21120_(context.m_43724_());
        if (stack.m_41782_() && (tag = stack.m_41783_()).m_128441_("PosX") && tag.m_128441_("PosY") && tag.m_128441_("PosZ") && tag.m_128441_("Side")) {
            BlockPos bp = new BlockPos(tag.m_128451_("PosX"), tag.m_128451_("PosY"), tag.m_128451_("PosZ"));
            BlockSide side = BlockSide.values()[tag.m_128445_("Side")];
            if (!(context.m_43725_().m_8055_(bp).m_60734_() instanceof ScreenBlock)) {
                return InteractionResult.SUCCESS;
            }
            BlockEntity te = context.m_43725_().m_7702_(bp);
            if (te == null || !(te instanceof ScreenBlockEntity)) {
                return InteractionResult.SUCCESS;
            }
            ScreenBlockEntity tes = (ScreenBlockEntity)te;
            ScreenData scr = tes.getScreen(side);
            if (scr == null) {
                return InteractionResult.SUCCESS;
            }
            Log.warning("Owner of screen at %d %d %d, side %s was changed from %s (UUID %s) to %s (UUID %s)", bp.m_123341_(), bp.m_123342_(), bp.m_123343_(), side.toString(), scr.owner.name, scr.owner.uuid.toString(), context.m_43723_().m_7755_(), context.m_43723_().m_36316_().getId().toString());
            context.m_43723_().m_21008_(context.m_43724_(), ItemStack.f_41583_);
            tes.setOwner(side, context.m_43723_());
            Util.toast(context.m_43723_(), ChatFormatting.AQUA, "newOwner", new Object[0]);
            return InteractionResult.SUCCESS;
        }
        if (!(context.m_43725_().m_8055_(context.m_8083_()).m_60734_() instanceof ScreenBlock)) {
            return InteractionResult.SUCCESS;
        }
        Vector3i pos = new Vector3i(context.m_8083_());
        BlockSide side = BlockSide.values()[context.m_43719_().ordinal()];
        Multiblock.findOrigin((LevelAccessor)context.m_43725_(), pos, side, null);
        BlockEntity te = context.m_43725_().m_7702_(pos.toBlock());
        if (te == null || !(te instanceof ScreenBlockEntity)) {
            Util.toast(context.m_43723_(), "turnOn", new Object[0]);
            return InteractionResult.SUCCESS;
        }
        if (((ScreenBlockEntity)te).getScreen(side) == null) {
            Util.toast(context.m_43723_(), "turnOn", new Object[0]);
        } else {
            CompoundTag tag2 = new CompoundTag();
            tag2.m_128405_("PosX", pos.x);
            tag2.m_128405_("PosY", pos.y);
            tag2.m_128405_("PosZ", pos.z);
            tag2.m_128344_("Side", (byte)side.ordinal());
            stack.m_41751_(tag2);
            Util.toast(context.m_43723_(), ChatFormatting.AQUA, "screenSet", new Object[0]);
            Log.warning("Player %s (UUID %s) created an Ownership Thief item for screen at %d %d %d, side %s!", context.m_43723_().m_7755_(), context.m_43723_().m_36316_().getId().toString(), pos.x, pos.y, pos.z, side.toString());
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    @Nullable
    public String getWikiName(@Nonnull ItemStack is) {
        return "Ownership_Thief";
    }
}

