/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.net.client_bound;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import net.montoyo.wd.WebDisplays;
import net.montoyo.wd.core.JSServerRequest;
import net.montoyo.wd.net.Packet;
import net.montoyo.wd.utilities.Log;

public class S2CMessageJSResponse
extends Packet {
    private int id;
    private JSServerRequest type;
    private boolean success;
    private byte[] data;
    private int errCode;
    private String errString;

    public S2CMessageJSResponse(int id, JSServerRequest t, byte[] d) {
        this.id = id;
        this.type = t;
        this.success = true;
        this.data = d;
    }

    public S2CMessageJSResponse(int id, JSServerRequest t, int code, String err) {
        this.id = id;
        this.type = t;
        this.success = false;
        this.errCode = code;
        this.errString = err;
    }

    public S2CMessageJSResponse(FriendlyByteBuf buf) {
        super(buf);
        int id = buf.readInt();
        JSServerRequest type = JSServerRequest.fromID(buf.readByte());
        boolean success = buf.readBoolean();
        byte[] data = null;
        if (success) {
            data = new byte[buf.readByte()];
            buf.readBytes(data);
            this.id = id;
            this.type = type;
            this.data = data;
        } else {
            int errCode = buf.readInt();
            String errString = buf.m_130277_();
            this.id = id;
            this.type = type;
            this.errCode = errCode;
            this.errString = errString;
        }
    }

    @Override
    public void m_5779_(FriendlyByteBuf buf) {
        buf.writeInt(this.id);
        buf.writeByte(this.type.ordinal());
        buf.writeBoolean(this.success);
        if (this.success) {
            buf.writeByte(this.data.length);
            buf.writeBytes(this.data);
        } else {
            buf.writeInt(this.errCode);
            buf.m_130070_(this.errString);
        }
    }

    @Override
    public void handle(NetworkEvent.Context ctx) {
        if (this.checkClient(ctx)) {
            ctx.enqueueWork(() -> {
                try {
                    if (this.success) {
                        WebDisplays.PROXY.handleJSResponseSuccess(this.id, this.type, this.data);
                    } else {
                        WebDisplays.PROXY.handleJSResponseError(this.id, this.type, this.errCode, this.errString);
                    }
                }
                catch (Throwable t) {
                    Log.warningEx("Could not handle JS response", t, new Object[0]);
                }
            });
            ctx.setPacketHandled(true);
        }
    }
}

