/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.net.server_bound;

import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import net.montoyo.wd.miniserv.server.ClientManager;
import net.montoyo.wd.miniserv.server.Server;
import net.montoyo.wd.net.BufferUtils;
import net.montoyo.wd.net.Packet;
import net.montoyo.wd.net.client_bound.S2CMessageMiniservKey;

public class C2SMessageMiniservConnect
extends Packet {
    private byte[] modulus;
    private byte[] exponent;

    public C2SMessageMiniservConnect(byte[] mod, byte[] exp) {
        this.modulus = mod;
        this.exponent = exp;
    }

    public C2SMessageMiniservConnect(FriendlyByteBuf buf) {
        super(buf);
        this.modulus = BufferUtils.readBytes(buf);
        this.exponent = BufferUtils.readBytes(buf);
    }

    @Override
    public void m_5779_(FriendlyByteBuf buf) {
        BufferUtils.writeBytes(buf, this.modulus);
        BufferUtils.writeBytes(buf, this.exponent);
    }

    @Override
    public void handle(NetworkEvent.Context ctx) {
        if (this.checkServer(ctx)) {
            try {
                ClientManager cliMgr = Server.getInstance().getClientManager();
                byte[] encKey = cliMgr.encryptClientKey(Objects.requireNonNull(ctx.getSender()).m_36316_().getId(), this.modulus, this.exponent);
                if (encKey != null) {
                    this.respond(ctx, new S2CMessageMiniservKey(encKey));
                }
                ctx.setPacketHandled(true);
            }
            catch (Throwable err) {
                err.printStackTrace();
                throw new RuntimeException(err);
            }
        }
    }
}

