/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.animation.types;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.registries.RegistryObject;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.AnimationPlayer;
import yesman.epicfight.api.animation.AnimationVariables;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.animation.property.MoveCoordFunctions;
import yesman.epicfight.api.animation.types.ActionAnimation;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.collider.Collider;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.api.utils.HitEntityList;
import yesman.epicfight.api.utils.math.MathUtils;
import yesman.epicfight.api.utils.math.ValueModifier;
import yesman.epicfight.particle.HitParticleType;
import yesman.epicfight.world.capabilities.entitypatch.HumanoidMobPatch;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.damagesource.EpicFightDamageSources;
import yesman.epicfight.world.damagesource.StunType;
import yesman.epicfight.world.entity.eventlistener.AttackEndEvent;
import yesman.epicfight.world.entity.eventlistener.AttackPhaseEndEvent;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class AttackAnimation
extends ActionAnimation {
    public static final AnimationVariables.SharedAnimationVariableKey<List<Entity>> ATTACK_TRIED_ENTITIES = AnimationVariables.shared(animator -> Lists.newArrayList(), false);
    public static final AnimationVariables.SharedAnimationVariableKey<List<LivingEntity>> ACTUALLY_HIT_ENTITIES = AnimationVariables.shared(animator -> Lists.newArrayList(), false);
    public final Phase[] phases;

    public AttackAnimation(float transitionTime, float antic, float preDelay, float contact, float recovery, @Nullable Collider collider, Joint colliderJoint, AnimationManager.AnimationAccessor<? extends AttackAnimation> accessor, AssetAccessor<? extends Armature> armature) {
        this(transitionTime, accessor, armature, new Phase(0.0f, antic, preDelay, contact, recovery, Float.MAX_VALUE, colliderJoint, collider));
    }

    public AttackAnimation(float transitionTime, float antic, float preDelay, float contact, float recovery, InteractionHand hand, @Nullable Collider collider, Joint colliderJoint, AnimationManager.AnimationAccessor<? extends AttackAnimation> accessor, AssetAccessor<? extends Armature> armature) {
        this(transitionTime, accessor, armature, new Phase(0.0f, antic, preDelay, contact, recovery, Float.MAX_VALUE, hand, colliderJoint, collider));
    }

    public AttackAnimation(float transitionTime, AnimationManager.AnimationAccessor<? extends AttackAnimation> accessor, AssetAccessor<? extends Armature> armature, Phase ... phases) {
        super(transitionTime, (AnimationManager.AnimationAccessor<? extends ActionAnimation>)accessor, armature);
        ((StaticAnimation)this).addProperty(AnimationProperty.ActionAnimationProperty.COORD_SET_BEGIN, MoveCoordFunctions.TRACE_TARGET_DISTANCE);
        ((StaticAnimation)this).addProperty(AnimationProperty.ActionAnimationProperty.COORD_SET_TICK, MoveCoordFunctions.TRACE_TARGET_DISTANCE);
        ((StaticAnimation)this).addProperty(AnimationProperty.ActionAnimationProperty.COORD_GET, MoveCoordFunctions.MODEL_COORD);
        ((StaticAnimation)this).addProperty(AnimationProperty.ActionAnimationProperty.DEST_LOCATION_PROVIDER, MoveCoordFunctions.ATTACK_TARGET_LOCATION);
        ((StaticAnimation)this).addProperty(AnimationProperty.ActionAnimationProperty.ENTITY_YROT_PROVIDER, MoveCoordFunctions.MOB_ATTACK_TARGET_LOOK);
        ((StaticAnimation)this).addProperty(AnimationProperty.ActionAnimationProperty.STOP_MOVEMENT, true);
        this.phases = phases;
        this.stateSpectrumBlueprint.clear();
        for (Phase phase : phases) {
            if (phase.noStateBind) continue;
            this.bindPhaseState(phase);
        }
    }

    public AttackAnimation(float convertTime, float antic, float preDelay, float contact, float recovery, InteractionHand hand, @Nullable Collider collider, Joint colliderJoint, String path, AssetAccessor<? extends Armature> armature) {
        this(convertTime, path, armature, new Phase(0.0f, antic, preDelay, contact, recovery, Float.MAX_VALUE, hand, colliderJoint, collider));
    }

    public AttackAnimation(float convertTime, String path, AssetAccessor<? extends Armature> armature, Phase ... phases) {
        super(convertTime, 0.0f, path, armature);
        ((StaticAnimation)this).addProperty(AnimationProperty.ActionAnimationProperty.COORD_SET_BEGIN, MoveCoordFunctions.TRACE_TARGET_DISTANCE);
        ((StaticAnimation)this).addProperty(AnimationProperty.ActionAnimationProperty.COORD_SET_TICK, MoveCoordFunctions.TRACE_TARGET_DISTANCE);
        ((StaticAnimation)this).addProperty(AnimationProperty.ActionAnimationProperty.COORD_GET, MoveCoordFunctions.MODEL_COORD);
        ((StaticAnimation)this).addProperty(AnimationProperty.ActionAnimationProperty.DEST_LOCATION_PROVIDER, MoveCoordFunctions.ATTACK_TARGET_LOCATION);
        ((StaticAnimation)this).addProperty(AnimationProperty.ActionAnimationProperty.ENTITY_YROT_PROVIDER, MoveCoordFunctions.MOB_ATTACK_TARGET_LOOK);
        ((StaticAnimation)this).addProperty(AnimationProperty.ActionAnimationProperty.STOP_MOVEMENT, true);
        this.phases = phases;
        this.stateSpectrumBlueprint.clear();
        for (Phase phase : phases) {
            if (phase.noStateBind) continue;
            this.bindPhaseState(phase);
        }
    }

    protected void bindPhaseState(Phase phase) {
        float preDelay = phase.preDelay;
        this.stateSpectrumBlueprint.newTimePair(phase.start, preDelay).addState(EntityState.PHASE_LEVEL, 1).newTimePair(phase.start, phase.contact).addState(EntityState.CAN_SKILL_EXECUTION, false).newTimePair(phase.start, phase.recovery).addState(EntityState.MOVEMENT_LOCKED, true).addState(EntityState.UPDATE_LIVING_MOTION, false).addState(EntityState.CAN_BASIC_ATTACK, false).newTimePair(phase.start, phase.end).addState(EntityState.INACTION, true).newTimePair(phase.antic, phase.end).addState(EntityState.TURNING_LOCKED, true).newTimePair(preDelay, phase.contact).addState(EntityState.ATTACKING, true).addState(EntityState.PHASE_LEVEL, 2).newTimePair(phase.contact, phase.end).addState(EntityState.PHASE_LEVEL, 3);
    }

    @Override
    public void begin(LivingEntityPatch<?> entitypatch) {
        super.begin(entitypatch);
        entitypatch.setLastAttackSuccess(false);
    }

    @Override
    public void linkTick(LivingEntityPatch<?> entitypatch, AssetAccessor<? extends DynamicAnimation> linkAnimation) {
        super.linkTick(entitypatch, linkAnimation);
        if (!entitypatch.isLogicalClient()) {
            this.attackTick(entitypatch, linkAnimation);
        }
    }

    @Override
    public void tick(LivingEntityPatch<?> entitypatch) {
        super.tick(entitypatch);
        if (!entitypatch.isLogicalClient()) {
            this.attackTick(entitypatch, this.getAccessor());
        }
    }

    @Override
    public void end(LivingEntityPatch<?> entitypatch, AssetAccessor<? extends DynamicAnimation> nextAnimation, boolean isEnd) {
        super.end(entitypatch, nextAnimation, isEnd);
        if (entitypatch instanceof ServerPlayerPatch) {
            ServerPlayerPatch playerpatch = (ServerPlayerPatch)entitypatch;
            if (isEnd) {
                playerpatch.getEventListener().triggerEvents(PlayerEventListener.EventType.ATTACK_ANIMATION_END_EVENT, new AttackEndEvent(playerpatch, this.getAccessor()));
            }
            AnimationPlayer player = ((Animator)entitypatch.getAnimator()).getPlayerFor(this.getAccessor());
            float elapsedTime = player.getElapsedTime();
            EntityState state = this.getState(entitypatch, elapsedTime);
            if (!isEnd && state.attacking()) {
                playerpatch.getEventListener().triggerEvents(PlayerEventListener.EventType.ATTACK_PHASE_END_EVENT, new AttackPhaseEndEvent(playerpatch, this.getAccessor(), this.getPhaseByTime(elapsedTime), this.getPhaseOrderByTime(elapsedTime)));
            }
        }
        if (entitypatch instanceof HumanoidMobPatch) {
            Mob entity;
            HumanoidMobPatch mobpatch = (HumanoidMobPatch)entitypatch;
            if (entitypatch.isLogicalClient() && (entity = (Mob)mobpatch.getOriginal()).m_5448_() != null && !entity.m_5448_().m_6084_()) {
                entity.m_6710_(null);
            }
        }
    }

    protected void attackTick(LivingEntityPatch<?> entitypatch, AssetAccessor<? extends DynamicAnimation> animation) {
        AnimationPlayer player = ((Animator)entitypatch.getAnimator()).getPlayerFor(this.getAccessor());
        float prevElapsedTime = player.getPrevElapsedTime();
        float elapsedTime = player.getElapsedTime();
        EntityState prevState = animation.get().getState(entitypatch, prevElapsedTime);
        EntityState state = animation.get().getState(entitypatch, elapsedTime);
        Phase phase = this.getPhaseByTime(animation.get().isLinkAnimation() ? 0.0f : elapsedTime);
        if (prevState.attacking() || state.attacking() || prevState.getLevel() <= 2 && state.getLevel() > 2) {
            if (!prevState.attacking() || phase != this.getPhaseByTime(prevElapsedTime) && (state.attacking() || prevState.getLevel() <= 2 && state.getLevel() > 2)) {
                entitypatch.onStrike(this, phase.hand);
                entitypatch.playSound(this.getSwingSound(entitypatch, phase), 0.0f, 0.0f);
                entitypatch.removeHurtEntities();
            }
            this.hurtCollidingEntities(entitypatch, prevElapsedTime, elapsedTime, prevState, state, phase);
            if ((!state.attacking() || elapsedTime >= this.getTotalTime()) && entitypatch instanceof ServerPlayerPatch) {
                ServerPlayerPatch playerpatch = (ServerPlayerPatch)entitypatch;
                playerpatch.getEventListener().triggerEvents(PlayerEventListener.EventType.ATTACK_PHASE_END_EVENT, new AttackPhaseEndEvent(playerpatch, this.getAccessor(), phase, this.getPhaseOrderByTime(elapsedTime)));
            }
        }
    }

    protected void hurtCollidingEntities(LivingEntityPatch<?> entitypatch, float prevElapsedTime, float elapsedTime, EntityState prevState, EntityState state, Phase phase) {
        LivingEntity entity = (LivingEntity)entitypatch.getOriginal();
        float prevPoseTime = prevState.attacking() ? prevElapsedTime : phase.preDelay;
        float poseTime = state.attacking() ? elapsedTime : phase.contact;
        List<Entity> list = this.getPhaseByTime(elapsedTime).getCollidingEntities(entitypatch, this, prevPoseTime, poseTime, this.getPlaySpeed(entitypatch, this));
        if (!list.isEmpty()) {
            HitEntityList hitEntities = new HitEntityList(entitypatch, list, phase.getProperty(AnimationProperty.AttackPhaseProperty.HIT_PRIORITY).orElse(HitEntityList.Priority.DISTANCE));
            int maxStrikes = this.getMaxStrikes(entitypatch, phase);
            while (entitypatch.getCurrentlyActuallyHitEntities().size() < maxStrikes && hitEntities.next()) {
                Entity target = hitEntities.getEntity();
                LivingEntity trueEntity = this.getTrueEntity(target);
                if (trueEntity == null || !trueEntity.m_6084_() || entitypatch.getCurrentlyAttackTriedEntities().contains(trueEntity) || entitypatch.isTargetInvulnerable(target) || !(target instanceof LivingEntity) && !(target instanceof PartEntity) || !MathUtils.canBeSeen(target, (Entity)entity, target.m_20270_((Entity)entity) + Math.max(target.m_20205_(), target.m_20206_()))) continue;
                EpicFightDamageSource damagesource = this.getEpicFightDamageSource(entitypatch, target, phase);
                int prevInvulTime = target.f_19802_;
                target.f_19802_ = 0;
                AttackResult attackResult = entitypatch.attack(damagesource, target, phase.hand);
                target.f_19802_ = prevInvulTime;
                if (attackResult.resultType.dealtDamage()) {
                    target.m_9236_().m_6263_(null, target.m_20185_(), target.m_20186_(), target.m_20189_(), this.getHitSound(entitypatch, phase), target.m_5720_(), 1.0f, 1.0f);
                    this.spawnHitParticle((ServerLevel)target.m_9236_(), entitypatch, target, phase);
                }
                entitypatch.getCurrentlyAttackTriedEntities().add((Entity)trueEntity);
                if (!attackResult.resultType.shouldCount()) continue;
                entitypatch.getCurrentlyActuallyHitEntities().add(trueEntity);
            }
        }
    }

    public LivingEntity getTrueEntity(Entity entity) {
        PartEntity partEntity;
        Entity parentEntity;
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            return livingEntity;
        }
        if (entity instanceof PartEntity && (parentEntity = (partEntity = (PartEntity)entity).getParent()) instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)parentEntity;
            return livingEntity;
        }
        return null;
    }

    protected int getMaxStrikes(LivingEntityPatch<?> entitypatch, Phase phase) {
        return phase.getProperty(AnimationProperty.AttackPhaseProperty.MAX_STRIKES_MODIFIER).map(valueModifier -> (int)ValueModifier.calculator().attach((ValueModifier)valueModifier).getResult(entitypatch.getMaxStrikes(phase.hand))).orElse(entitypatch.getMaxStrikes(phase.hand));
    }

    protected SoundEvent getSwingSound(LivingEntityPatch<?> entitypatch, Phase phase) {
        return phase.getProperty(AnimationProperty.AttackPhaseProperty.SWING_SOUND).orElse(entitypatch.getSwingSound(phase.hand));
    }

    protected SoundEvent getHitSound(LivingEntityPatch<?> entitypatch, Phase phase) {
        return phase.getProperty(AnimationProperty.AttackPhaseProperty.HIT_SOUND).orElse(entitypatch.getWeaponHitSound(phase.hand));
    }

    public EpicFightDamageSource getEpicFightDamageSource(LivingEntityPatch<?> entitypatch, Entity target, Phase phase) {
        return this.getEpicFightDamageSource(entitypatch.getDamageSource(this.getAccessor(), phase.hand), entitypatch, target, phase);
    }

    public EpicFightDamageSource getEpicFightDamageSource(DamageSource originalSource, LivingEntityPatch<?> entitypatch, Entity target, Phase phase) {
        EpicFightDamageSource epicfightDamageSource;
        if (phase == null) {
            phase = this.getPhaseByTime(((Animator)entitypatch.getAnimator()).getPlayerFor(this.getAccessor()).getElapsedTime());
        }
        EpicFightDamageSource epicfightSource = originalSource instanceof EpicFightDamageSource ? (epicfightDamageSource = (EpicFightDamageSource)originalSource) : EpicFightDamageSources.fromVanillaDamageSource(originalSource).setAnimation(this.getAccessor());
        phase.getProperty(AnimationProperty.AttackPhaseProperty.DAMAGE_MODIFIER).ifPresent(opt -> epicfightSource.attachDamageModifier((ValueModifier)opt));
        phase.getProperty(AnimationProperty.AttackPhaseProperty.ARMOR_NEGATION_MODIFIER).ifPresent(opt -> epicfightSource.attachArmorNegationModifier((ValueModifier)opt));
        phase.getProperty(AnimationProperty.AttackPhaseProperty.IMPACT_MODIFIER).ifPresent(opt -> epicfightSource.attachImpactModifier((ValueModifier)opt));
        phase.getProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE).ifPresent(opt -> epicfightSource.setStunType((StunType)((Object)opt)));
        phase.getProperty(AnimationProperty.AttackPhaseProperty.SOURCE_TAG).ifPresent(opt -> opt.forEach(epicfightSource::addRuntimeTag));
        phase.getProperty(AnimationProperty.AttackPhaseProperty.EXTRA_DAMAGE).ifPresent(opt -> opt.forEach(epicfightSource::addExtraDamage));
        phase.getProperty(AnimationProperty.AttackPhaseProperty.SOURCE_LOCATION_PROVIDER).ifPresentOrElse(opt -> epicfightSource.setInitialPosition((Vec3)opt.apply(entitypatch)), () -> epicfightSource.setInitialPosition(((LivingEntity)entitypatch.getOriginal()).m_20182_()));
        return epicfightSource;
    }

    protected void spawnHitParticle(ServerLevel world, LivingEntityPatch<?> attacker, Entity hit, Phase phase) {
        Optional<RegistryObject<HitParticleType>> particleOptional = phase.getProperty(AnimationProperty.AttackPhaseProperty.PARTICLE);
        HitParticleType particle = particleOptional.isPresent() ? (HitParticleType)((Object)particleOptional.get().get()) : attacker.getWeaponHitParticle(phase.hand);
        particle.spawnParticleWithArgument(world, null, null, hit, (Entity)attacker.getOriginal());
    }

    @Override
    public float getPlaySpeed(LivingEntityPatch<?> entitypatch, DynamicAnimation animation) {
        if (entitypatch instanceof PlayerPatch) {
            PlayerPatch playerpatch = (PlayerPatch)entitypatch;
            Phase phase = this.getPhaseByTime(((Animator)playerpatch.getAnimator()).getPlayerFor(this.getAccessor()).getElapsedTime());
            float speedFactor = this.getProperty(AnimationProperty.AttackAnimationProperty.ATTACK_SPEED_FACTOR).orElse(Float.valueOf(1.0f)).floatValue();
            Optional<Float> property = this.getProperty(AnimationProperty.AttackAnimationProperty.BASIS_ATTACK_SPEED);
            float correctedSpeed = property.map(value -> Float.valueOf(playerpatch.getAttackSpeed(phase.hand) / value.floatValue())).orElse(Float.valueOf(this.getTotalTime() * playerpatch.getAttackSpeed(phase.hand))).floatValue();
            correctedSpeed = (float)Math.round(correctedSpeed * 1000.0f) / 1000.0f;
            return 1.0f + (correctedSpeed - 1.0f) * speedFactor;
        }
        return 1.0f;
    }

    public <V, A extends AttackAnimation> A addProperty(AnimationProperty.AttackPhaseProperty<V> propertyType, V value) {
        return this.addProperty(propertyType, value, 0);
    }

    public <V, A extends AttackAnimation> A addProperty(AnimationProperty.AttackPhaseProperty<V> propertyType, V value, int index) {
        this.phases[index].addProperty(propertyType, value);
        return (A)this;
    }

    public <A extends AttackAnimation> A removeProperty(AnimationProperty.AttackPhaseProperty<?> propertyType) {
        return this.removeProperty(propertyType, 0);
    }

    public <A extends AttackAnimation> A removeProperty(AnimationProperty.AttackPhaseProperty<?> propertyType, int index) {
        this.phases[index].removeProperty(propertyType);
        return (A)this;
    }

    public Phase getPhaseByTime(float elapsedTime) {
        Phase currentPhase = null;
        Phase[] phaseArray = this.phases;
        int n = phaseArray.length;
        for (int i = 0; i < n; ++i) {
            Phase phase;
            currentPhase = phase = phaseArray[i];
            if (phase.end > elapsedTime) break;
        }
        return currentPhase;
    }

    public int getPhaseOrderByTime(float elapsedTime) {
        int i = 0;
        for (Phase phase : this.phases) {
            if (phase.end > elapsedTime) break;
            ++i;
        }
        return i;
    }

    @Override
    public Object getModifiedLinkState(EntityState.StateFactor<?> factor, Object val, LivingEntityPatch<?> entitypatch, float elapsedTime) {
        if (factor == EntityState.ATTACKING && elapsedTime < this.getPlaySpeed(entitypatch, this) * 0.05f) {
            return false;
        }
        return val;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderDebugging(PoseStack poseStack, MultiBufferSource buffer, LivingEntityPatch<?> entitypatch, float playbackTime, float partialTicks) {
        AnimationPlayer animPlayer = ((Animator)entitypatch.getAnimator()).getPlayerFor(this.getAccessor());
        float prevElapsedTime = animPlayer.getPrevElapsedTime();
        float elapsedTime = animPlayer.getElapsedTime();
        Phase phase = this.getPhaseByTime(playbackTime);
        for (JointColliderPair colliderInfo : phase.colliders) {
            Collider collider = (Collider)colliderInfo.getSecond();
            if (collider == null) {
                collider = entitypatch.getColliderMatching(phase.hand);
            }
            collider.draw(poseStack, buffer, entitypatch, this, (Joint)colliderInfo.getFirst(), prevElapsedTime, elapsedTime, partialTicks, this.getPlaySpeed(entitypatch, this));
        }
    }

    public static class Phase {
        private final Map<AnimationProperty.AttackPhaseProperty<?>, Object> properties = Maps.newHashMap();
        public final float start;
        public final float antic;
        public final float preDelay;
        public final float contact;
        public final float recovery;
        public final float end;
        public final InteractionHand hand;
        public JointColliderPair[] colliders;
        public final boolean noStateBind;

        public Phase(float start, float antic, float contact, float recovery, float end, Joint joint, Collider collider) {
            this(start, antic, contact, recovery, end, InteractionHand.MAIN_HAND, joint, collider);
        }

        public Phase(float start, float antic, float contact, float recovery, float end, InteractionHand hand, Joint joint, Collider collider) {
            this(start, antic, antic, contact, recovery, end, hand, joint, collider);
        }

        public Phase(float start, float antic, float preDelay, float contact, float recovery, float end, Joint joint, Collider collider) {
            this(start, antic, preDelay, contact, recovery, end, InteractionHand.MAIN_HAND, joint, collider);
        }

        public Phase(float start, float antic, float preDelay, float contact, float recovery, float end, InteractionHand hand, Joint joint, Collider collider) {
            this(start, antic, preDelay, contact, recovery, end, false, hand, joint, collider);
        }

        public Phase(InteractionHand hand, Joint joint, Collider collider) {
            this(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, true, hand, joint, collider);
        }

        public Phase(float start, float antic, float preDelay, float contact, float recovery, float end, boolean noStateBind, InteractionHand hand, Joint joint, Collider collider) {
            this(start, antic, preDelay, contact, recovery, end, noStateBind, hand, JointColliderPair.of(joint, collider));
        }

        public Phase(float start, float antic, float preDelay, float contact, float recovery, float end, InteractionHand hand, JointColliderPair ... colliders) {
            this(start, antic, preDelay, contact, recovery, end, false, hand, colliders);
        }

        public Phase(float start, float antic, float preDelay, float contact, float recovery, float end, boolean noStateBind, InteractionHand hand, JointColliderPair ... colliders) {
            if (start > end) {
                throw new IllegalArgumentException("Phase create exception: Start time is bigger than end time");
            }
            this.start = start;
            this.antic = antic;
            this.preDelay = preDelay;
            this.contact = contact;
            this.recovery = recovery;
            this.end = end;
            this.colliders = colliders;
            this.hand = hand;
            this.noStateBind = noStateBind;
        }

        public <V> Phase addProperty(AnimationProperty.AttackPhaseProperty<V> propertyType, V value) {
            this.properties.put(propertyType, value);
            return this;
        }

        public Phase removeProperty(AnimationProperty.AttackPhaseProperty<?> propertyType) {
            this.properties.remove(propertyType);
            return this;
        }

        public void addProperties(Set<Map.Entry<AnimationProperty.AttackPhaseProperty<?>, Object>> set) {
            for (Map.Entry<AnimationProperty.AttackPhaseProperty<?>, Object> entry : set) {
                this.properties.put(entry.getKey(), entry.getValue());
            }
        }

        public <V> Optional<V> getProperty(AnimationProperty.AttackPhaseProperty<V> propertyType) {
            return Optional.ofNullable(this.properties.get(propertyType));
        }

        public List<Entity> getCollidingEntities(LivingEntityPatch<?> entitypatch, AttackAnimation animation, float prevElapsedTime, float elapsedTime, float attackSpeed) {
            HashSet entities = Sets.newHashSet();
            for (JointColliderPair colliderInfo : this.colliders) {
                Collider collider = (Collider)colliderInfo.getSecond();
                if (collider == null) {
                    collider = entitypatch.getColliderMatching(this.hand);
                }
                entities.addAll(collider.updateAndSelectCollideEntity(entitypatch, animation, prevElapsedTime, elapsedTime, (Joint)colliderInfo.getFirst(), attackSpeed));
            }
            return new ArrayList<Entity>(entities);
        }

        public JointColliderPair[] getColliders() {
            return this.colliders;
        }

        public InteractionHand getHand() {
            return this.hand;
        }
    }

    public static class JointColliderPair
    extends Pair<Joint, Collider> {
        public JointColliderPair(Joint first, Collider second) {
            super((Object)first, (Object)second);
        }

        public static JointColliderPair of(Joint joint, Collider collider) {
            return new JointColliderPair(joint, collider);
        }
    }
}

