/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.events.engine;

import com.google.common.collect.Sets;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.Input;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.MovementInputUpdateEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.lwjgl.glfw.GLFW;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.client.ClientEngine;
import yesman.epicfight.client.gui.screen.SkillEditScreen;
import yesman.epicfight.client.gui.screen.config.IngameConfigurationScreen;
import yesman.epicfight.client.input.EpicFightKeyMappings;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.config.ClientConfig;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.skill.modules.ChargeableSkill;
import yesman.epicfight.skill.modules.HoldableSkill;
import yesman.epicfight.world.entity.eventlistener.MovementInputEvent;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;
import yesman.epicfight.world.entity.eventlistener.SkillCastEvent;
import yesman.epicfight.world.gamerule.EpicFightGameRules;

@OnlyIn(value=Dist.CLIENT)
public class ControlEngine {
    private final Set<Object> packets = Sets.newHashSet();
    private final Minecraft minecraft;
    private LocalPlayer player;
    private LocalPlayerPatch playerPatch;
    private int weaponInnatePressCounter = 0;
    private int sneakPressCounter = 0;
    private int moverPressCounter = 0;
    private int tickSinceLastJump = 0;
    private int lastHotbarLockedTime;
    private boolean weaponInnatePressToggle = false;
    private boolean sneakPressToggle = false;
    private boolean moverPressToggle = false;
    private boolean attackLightPressToggle = false;
    private boolean hotbarLocked;
    private boolean holdingFinished;
    private int reserveCounter;
    private KeyMapping reservedKey;
    private SkillSlot reservedOrHoldingSkillSlot;
    private KeyMapping currentHoldingKey;
    public Options options;

    public ControlEngine() {
        Events.controlEngine = this;
        this.minecraft = Minecraft.m_91087_();
        this.options = this.minecraft.f_91066_;
    }

    public void setPlayerPatch(LocalPlayerPatch playerPatch) {
        this.weaponInnatePressCounter = 0;
        this.weaponInnatePressToggle = false;
        this.sneakPressCounter = 0;
        this.sneakPressToggle = false;
        this.attackLightPressToggle = false;
        this.player = (LocalPlayer)playerPatch.getOriginal();
        this.playerPatch = playerPatch;
    }

    public LocalPlayerPatch getPlayerPatch() {
        return this.playerPatch;
    }

    public boolean canPlayerMove(EntityState playerState) {
        return !playerState.movementLocked() || this.player.m_245714_() != null;
    }

    public boolean canPlayerRotate(EntityState playerState) {
        return !playerState.turningLocked() || this.player.m_245714_() != null;
    }

    public void handleEpicFightKeyMappings() {
        SkillContainer container;
        SkillContainer skill;
        if (this.playerPatch == null) {
            return;
        }
        if (ControlEngine.isKeyPressed(EpicFightKeyMappings.SKILL_EDIT, false) && this.playerPatch.getSkillCapability() != null) {
            Minecraft.m_91087_().m_91152_((Screen)new SkillEditScreen((Player)this.player, this.playerPatch.getSkillCapability()));
        }
        if (ControlEngine.isKeyPressed(EpicFightKeyMappings.OPEN_CONFIG_SCREEN, false)) {
            Minecraft.m_91087_().m_91152_((Screen)new IngameConfigurationScreen(null));
        }
        if (ControlEngine.isKeyPressed(EpicFightKeyMappings.SWITCH_VANILLA_MODEL_DEBUGGING, false)) {
            boolean flag = ClientEngine.getInstance().switchVanillaModelDebuggingMode();
            this.minecraft.f_91068_.m_90913_(flag ? "debug.vanilla_model_debugging.on" : "debug.vanilla_model_debugging.off", new Object[0]);
        }
        while (ControlEngine.isKeyPressed(EpicFightKeyMappings.ATTACK, true)) {
            if (!this.playerPatch.isEpicFightMode() || this.currentHoldingKey == EpicFightKeyMappings.ATTACK) continue;
            boolean shouldPlayAttackAnimation = this.playerPatch.canPlayAttackAnimation();
            if (this.options.f_92096_.getKey() == EpicFightKeyMappings.ATTACK.getKey() && this.minecraft.f_91077_ != null && shouldPlayAttackAnimation) {
                ControlEngine.makeUnpressed(this.options.f_92096_);
            }
            if (!shouldPlayAttackAnimation) continue;
            if (!EpicFightKeyMappings.ATTACK.getKey().equals((Object)EpicFightKeyMappings.WEAPON_INNATE_SKILL.getKey())) {
                SkillContainer airSlash = this.playerPatch.getSkill(SkillSlots.AIR_ATTACK);
                SkillSlots slot = this.tickSinceLastJump > 0 && airSlash.getSkill() != null && airSlash.getSkill().canExecute(airSlash) ? SkillSlots.AIR_ATTACK : SkillSlots.BASIC_ATTACK;
                SkillCastEvent skillCastEvent = this.playerPatch.getSkill(slot).sendCastRequest(this.playerPatch, this);
                if (skillCastEvent.isExecutable()) {
                    this.player.m_36334_();
                    this.attackLightPressToggle = false;
                    this.releaseAllServedKeys();
                } else if (!this.player.m_5833_() && slot == SkillSlots.BASIC_ATTACK) {
                    this.reserveKey(slot, EpicFightKeyMappings.ATTACK);
                }
                this.lockHotkeys();
                this.attackLightPressToggle = false;
                this.weaponInnatePressToggle = false;
                this.weaponInnatePressCounter = 0;
                continue;
            }
            if (this.weaponInnatePressToggle) continue;
            this.weaponInnatePressToggle = true;
        }
        while (ControlEngine.isKeyPressed(EpicFightKeyMappings.DODGE, true)) {
            if (!this.playerPatch.isEpicFightMode() || this.currentHoldingKey == EpicFightKeyMappings.DODGE) continue;
            if (EpicFightKeyMappings.DODGE.getKey().m_84873_() == this.options.f_92090_.getKey().m_84873_()) {
                if (this.player.m_20202_() != null || this.sneakPressToggle) continue;
                this.sneakPressToggle = true;
                continue;
            }
            SkillSlots skillCategory = this.playerPatch.getEntityState().knockDown() ? SkillSlots.KNOCKDOWN_WAKEUP : SkillSlots.DODGE;
            skill = this.playerPatch.getSkill(skillCategory);
            if (skill.isEmpty() || !skill.sendCastRequest(this.playerPatch, this).shouldReserveKey()) continue;
            this.reserveKey(SkillSlots.DODGE, EpicFightKeyMappings.DODGE);
        }
        if (ControlEngine.isKeyDown(EpicFightKeyMappings.GUARD) && this.playerPatch.isEpicFightMode() && this.currentHoldingKey != EpicFightKeyMappings.GUARD && !this.playerPatch.isHoldingAny()) {
            boolean hasUseAction = false;
            if (ClientConfig.resolveKeyConflicts && EpicFightKeyMappings.GUARD.getKey().equals((Object)this.options.f_92095_.getKey()) && (this.player.m_21205_().m_41780_() != UseAnim.NONE || this.player.m_21206_().m_41780_() != UseAnim.NONE)) {
                hasUseAction = true;
            }
            if (!hasUseAction) {
                SkillCastEvent skillCastEvent = this.playerPatch.getSkill(SkillSlots.GUARD).sendCastRequest(this.playerPatch, this);
                if (skillCastEvent.shouldReserveKey()) {
                    if (!this.player.m_5833_()) {
                        this.reserveKey(SkillSlots.GUARD, EpicFightKeyMappings.GUARD);
                    }
                } else {
                    this.lockHotkeys();
                }
            }
        }
        while (ControlEngine.isKeyPressed(EpicFightKeyMappings.WEAPON_INNATE_SKILL, true)) {
            if (!this.playerPatch.isEpicFightMode() || this.currentHoldingKey == EpicFightKeyMappings.WEAPON_INNATE_SKILL || EpicFightKeyMappings.ATTACK.getKey().equals((Object)EpicFightKeyMappings.WEAPON_INNATE_SKILL.getKey())) continue;
            if (this.playerPatch.getSkill(SkillSlots.WEAPON_INNATE).sendCastRequest(this.playerPatch, this).shouldReserveKey()) {
                if (this.player.m_5833_()) continue;
                this.reserveKey(SkillSlots.WEAPON_INNATE, EpicFightKeyMappings.WEAPON_INNATE_SKILL);
                continue;
            }
            this.lockHotkeys();
        }
        while (ControlEngine.isKeyPressed(EpicFightKeyMappings.MOVER_SKILL, true)) {
            if (!this.playerPatch.isEpicFightMode() || this.playerPatch.isHoldingAny()) continue;
            if (EpicFightKeyMappings.MOVER_SKILL.getKey().m_84873_() == this.options.f_92089_.getKey().m_84873_()) {
                SkillCastEvent event;
                SkillContainer skillContainer = this.playerPatch.getSkill(SkillSlots.MOVER);
                if (skillContainer.isEmpty() || !skillContainer.canUse(this.playerPatch, event = new SkillCastEvent(this.playerPatch, skillContainer, skillContainer.getSkill().gatherArguments(skillContainer, this))) || this.player.m_20202_() != null || this.moverPressToggle) continue;
                this.moverPressToggle = true;
                continue;
            }
            SkillContainer skill2 = this.playerPatch.getSkill(SkillSlots.MOVER);
            skill2.sendCastRequest(this.playerPatch, this);
        }
        while (ControlEngine.isKeyPressed(EpicFightKeyMappings.SWITCH_MODE, false)) {
            if (EpicFightGameRules.CAN_SWITCH_PLAYER_MODE.getRuleValue(((LocalPlayer)this.playerPatch.getOriginal()).m_9236_()).booleanValue()) {
                this.playerPatch.toggleMode();
                continue;
            }
            this.minecraft.f_91065_.m_93076_().m_93785_((Component)Component.m_237115_((String)"epicfight.messages.mode_switching_disabled").m_130940_(ChatFormatting.RED));
        }
        while (ControlEngine.isKeyPressed(EpicFightKeyMappings.LOCK_ON, false)) {
            this.playerPatch.toggleLockOn();
        }
        if (this.playerPatch.getEntityState().inaction() || !this.playerPatch.getHoldingItemCapability(InteractionHand.MAIN_HAND).canBePlacedOffhand()) {
            ControlEngine.makeUnpressed(this.minecraft.f_91066_.f_92093_);
        }
        if (!this.playerPatch.isEpicFightMode() || Minecraft.m_91087_().m_91104_()) {
            return;
        }
        if (this.player.f_19797_ - this.lastHotbarLockedTime > 20 && this.hotbarLocked) {
            this.unlockHotkeys();
        }
        if (this.weaponInnatePressToggle) {
            if (!ControlEngine.isKeyDown(EpicFightKeyMappings.WEAPON_INNATE_SKILL)) {
                this.attackLightPressToggle = true;
                this.weaponInnatePressToggle = false;
                this.weaponInnatePressCounter = 0;
            } else if (EpicFightKeyMappings.WEAPON_INNATE_SKILL.getKey().equals((Object)EpicFightKeyMappings.ATTACK.getKey())) {
                if (this.weaponInnatePressCounter > ClientConfig.longPressCounter) {
                    if (this.playerPatch.getSkill(SkillSlots.WEAPON_INNATE).sendCastRequest(this.playerPatch, this).shouldReserveKey()) {
                        if (!this.player.m_5833_()) {
                            this.reserveKey(SkillSlots.WEAPON_INNATE, EpicFightKeyMappings.WEAPON_INNATE_SKILL);
                        }
                    } else {
                        this.lockHotkeys();
                    }
                    this.weaponInnatePressToggle = false;
                    this.weaponInnatePressCounter = 0;
                } else {
                    ++this.weaponInnatePressCounter;
                }
            }
        }
        if (this.attackLightPressToggle) {
            SkillContainer airSlash = this.playerPatch.getSkill(SkillSlots.AIR_ATTACK);
            SkillSlots slot = this.tickSinceLastJump > 0 && airSlash.getSkill() != null && airSlash.getSkill().canExecute(airSlash) ? SkillSlots.AIR_ATTACK : SkillSlots.BASIC_ATTACK;
            SkillCastEvent skillCastEvent = this.playerPatch.getSkill(slot).sendCastRequest(this.playerPatch, this);
            if (skillCastEvent.isExecutable()) {
                this.player.m_36334_();
                this.releaseAllServedKeys();
            } else if (!this.player.m_5833_() && slot == SkillSlots.BASIC_ATTACK) {
                this.reserveKey(slot, EpicFightKeyMappings.ATTACK);
            }
            this.lockHotkeys();
            this.attackLightPressToggle = false;
            this.weaponInnatePressToggle = false;
            this.weaponInnatePressCounter = 0;
        }
        if (this.sneakPressToggle) {
            if (!ControlEngine.isKeyDown(this.options.f_92090_)) {
                SkillSlots skillSlot = this.playerPatch.getEntityState().knockDown() ? SkillSlots.KNOCKDOWN_WAKEUP : SkillSlots.DODGE;
                skill = this.playerPatch.getSkill(skillSlot);
                if (skill.sendCastRequest(this.playerPatch, this).shouldReserveKey()) {
                    this.reserveKey(skillSlot, this.options.f_92090_);
                }
                this.sneakPressToggle = false;
                this.sneakPressCounter = 0;
            } else if (this.sneakPressCounter > ClientConfig.longPressCounter) {
                this.sneakPressToggle = false;
                this.sneakPressCounter = 0;
            } else {
                ++this.sneakPressCounter;
            }
        }
        if (this.currentHoldingKey != null && !(container = this.playerPatch.getSkill(this.reservedOrHoldingSkillSlot)).isEmpty()) {
            if (container.getSkill() instanceof HoldableSkill) {
                Skill skill3;
                if (!ControlEngine.isKeyDown(this.currentHoldingKey)) {
                    this.holdingFinished = true;
                }
                if ((skill3 = container.getSkill()) instanceof ChargeableSkill) {
                    ChargeableSkill chargingSkill = (ChargeableSkill)((Object)skill3);
                    if (this.holdingFinished) {
                        if (this.playerPatch.getSkillChargingTicks() > chargingSkill.getMinChargingTicks()) {
                            container.sendCastRequest(this.playerPatch, this);
                            this.releaseAllServedKeys();
                        }
                    } else if (this.playerPatch.getSkillChargingTicks() >= chargingSkill.getAllowedMaxChargingTicks()) {
                        this.releaseAllServedKeys();
                    }
                } else if (this.holdingFinished) {
                    this.playerPatch.resetHolding();
                    container.getSkill().cancelOnClient(container, container.getSkill().gatherArguments(container, this));
                    container.sendCancelRequest(this.playerPatch, this);
                    this.releaseAllServedKeys();
                }
            } else {
                this.releaseAllServedKeys();
            }
        }
        if (this.reservedKey != null) {
            if (this.reserveCounter > 0) {
                SkillContainer skill4 = this.playerPatch.getSkill(this.reservedOrHoldingSkillSlot);
                --this.reserveCounter;
                if (skill4.getSkill() != null && skill4.sendCastRequest(this.playerPatch, this).isExecutable()) {
                    this.releaseAllServedKeys();
                    this.lockHotkeys();
                }
            } else {
                this.releaseAllServedKeys();
            }
        }
        if (!this.playerPatch.getEntityState().canSwitchHoldingItem() || this.hotbarLocked) {
            for (int i = 0; i < 9; ++i) {
                while (this.options.f_92056_[i].m_90859_()) {
                }
            }
            while (this.options.f_92094_.m_90859_()) {
            }
        }
    }

    private void inputTick(Input input) {
        if (this.moverPressToggle) {
            if (!ControlEngine.isKeyDown(this.options.f_92089_)) {
                this.moverPressToggle = false;
                this.moverPressCounter = 0;
                if (this.player.m_20096_()) {
                    this.player.f_20954_ = 0;
                    input.f_108572_ = true;
                }
            } else if (this.moverPressCounter > ClientConfig.longPressCounter) {
                SkillContainer skill = this.playerPatch.getSkill(SkillSlots.MOVER);
                skill.sendCastRequest(this.playerPatch, this);
                this.moverPressToggle = false;
                this.moverPressCounter = 0;
            } else {
                this.player.f_20954_ = 2;
                ++this.moverPressCounter;
            }
        }
        if (!this.canPlayerMove(this.playerPatch.getEntityState())) {
            input.f_108567_ = 0.0f;
            input.f_108566_ = 0.0f;
            input.f_108568_ = false;
            input.f_108569_ = false;
            input.f_108570_ = false;
            input.f_108571_ = false;
            input.f_108572_ = false;
            input.f_108573_ = false;
            this.player.f_108583_ = -1;
            this.player.m_6858_(false);
        }
        if (this.player.m_6084_()) {
            this.playerPatch.getEventListener().triggerEvents(PlayerEventListener.EventType.MOVEMENT_INPUT_EVENT, new MovementInputEvent(this.playerPatch, input));
        }
        if (this.tickSinceLastJump > 0) {
            --this.tickSinceLastJump;
        }
    }

    private void reserveKey(SkillSlot slot, KeyMapping keyMapping) {
        this.reservedKey = keyMapping;
        this.reservedOrHoldingSkillSlot = slot;
        this.reserveCounter = 8;
    }

    public void releaseAllServedKeys() {
        this.holdingFinished = true;
        this.currentHoldingKey = null;
        this.reservedOrHoldingSkillSlot = null;
        this.reserveCounter = -1;
        this.reservedKey = null;
    }

    public void setHoldingKey(SkillSlot chargingSkillSlot, KeyMapping keyMapping) {
        this.holdingFinished = false;
        this.currentHoldingKey = keyMapping;
        this.reservedOrHoldingSkillSlot = chargingSkillSlot;
        this.reserveCounter = -1;
        this.reservedKey = null;
    }

    public void lockHotkeys() {
        this.hotbarLocked = true;
        this.lastHotbarLockedTime = this.player.f_19797_;
        for (int i = 0; i < 9; ++i) {
            while (this.options.f_92056_[i].m_90859_()) {
            }
        }
    }

    public void unlockHotkeys() {
        this.hotbarLocked = false;
    }

    public void addPacketToSend(Object packet) {
        this.packets.add(packet);
    }

    public static boolean isKeyDown(KeyMapping key) {
        if (key.getKey().m_84868_() == InputConstants.Type.KEYSYM) {
            return key.m_90857_() || GLFW.glfwGetKey((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)key.getKey().m_84873_()) > 0;
        }
        if (key.getKey().m_84868_() == InputConstants.Type.MOUSE) {
            return key.m_90857_() || GLFW.glfwGetMouseButton((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)key.getKey().m_84873_()) > 0;
        }
        return false;
    }

    private static boolean isKeyPressed(KeyMapping key, boolean eventCheck) {
        int mouseButton;
        InputEvent.InteractionKeyMappingTriggered inputEvent;
        boolean consumes = key.m_90859_();
        if (consumes && eventCheck && (inputEvent = ForgeHooksClient.onClickInput((int)(mouseButton = InputConstants.Type.MOUSE == key.getKey().m_84868_() ? key.getKey().m_84873_() : -1), (KeyMapping)key, (InteractionHand)InteractionHand.MAIN_HAND)).isCanceled()) {
            return false;
        }
        return consumes;
    }

    public static void makeUnpressed(KeyMapping keyMapping) {
        while (keyMapping.m_90859_()) {
        }
        ControlEngine.setKeyBind(keyMapping, false);
    }

    public static void setKeyBind(KeyMapping key, boolean setter) {
        KeyMapping.m_90837_((InputConstants.Key)key.getKey(), (boolean)setter);
    }

    public boolean moverToggling() {
        return this.moverPressToggle;
    }

    public boolean sneakToggling() {
        return this.sneakPressToggle;
    }

    public boolean attackToggling() {
        return this.attackLightPressToggle;
    }

    public boolean weaponInnateToggling() {
        return this.weaponInnatePressToggle;
    }

    @OnlyIn(value=Dist.CLIENT)
    @Mod.EventBusSubscriber(modid="epicfight", value={Dist.CLIENT})
    public static class Events {
        static ControlEngine controlEngine;

        @SubscribeEvent
        public static void livingJumpEvent(LivingEvent.LivingJumpEvent event) {
            if (event.getEntity() == Events.controlEngine.player) {
                Events.controlEngine.tickSinceLastJump = 5;
            }
        }

        @SubscribeEvent
        public static void mouseScrollEvent(InputEvent.MouseScrollingEvent event) {
            if (Events.controlEngine.minecraft.f_91074_ != null && Events.controlEngine.playerPatch != null && !Events.controlEngine.playerPatch.getEntityState().canSwitchHoldingItem() && Events.controlEngine.minecraft.f_91080_ == null) {
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void moveInputEvent(MovementInputUpdateEvent event) {
            if (Events.controlEngine.playerPatch == null) {
                return;
            }
            controlEngine.inputTick(event.getInput());
        }

        @SubscribeEvent
        public static void clientTickEndEvent(TickEvent.ClientTickEvent event) {
            if (Events.controlEngine.minecraft.f_91074_ == null) {
                return;
            }
            if (event.phase == TickEvent.Phase.END) {
                for (Object packet : Events.controlEngine.packets) {
                    EpicFightNetworkManager.sendToServer(packet);
                }
                Events.controlEngine.packets.clear();
            }
        }

        @SubscribeEvent
        public static void interactionEvent(InputEvent.InteractionKeyMappingTriggered event) {
            if (Events.controlEngine.minecraft.f_91074_ == null) {
                return;
            }
            if (event.getKeyMapping() == Events.controlEngine.minecraft.f_91066_.f_92096_ && EpicFightKeyMappings.ATTACK.getKey() == Events.controlEngine.minecraft.f_91066_.f_92096_.getKey() && Events.controlEngine.minecraft.f_91077_.m_6662_() == HitResult.Type.BLOCK && ClientConfig.combatPreferredItems.contains(Events.controlEngine.player.m_21205_().m_41720_())) {
                BlockPos bp = ((BlockHitResult)Events.controlEngine.minecraft.f_91077_).m_82425_();
                BlockState bs = Events.controlEngine.minecraft.f_91073_.m_8055_(bp);
                if (!Events.controlEngine.player.m_21205_().m_41720_().m_6777_(bs, Events.controlEngine.player.m_9236_(), bp, (Player)Events.controlEngine.player) || Events.controlEngine.player.m_21205_().m_41691_(bs) <= 1.0f) {
                    event.setSwingHand(false);
                    event.setCanceled(true);
                }
            }
        }
    }
}

