/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.renderer;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.ModelData;
import org.joml.Matrix4f;
import org.joml.Vector4f;
import org.lwjgl.system.MemoryStack;

@OnlyIn(value=Dist.CLIENT)
public class ImaginaryBlockRenderer {
    private static final Direction[] DIRECTIONS = Direction.values();

    public void render(Camera camera, PoseStack poseStack, MultiBufferSource buffers, Level level, BlockPos bp, float r, float g, float b, float a) {
        BlockState bs = level.m_8055_(bp);
        BakedModel model = Minecraft.m_91087_().m_91289_().m_110910_(bs);
        RandomSource randomsource = RandomSource.m_216327_();
        long seed = bs.m_60726_(bp);
        randomsource.m_188584_(seed);
        poseStack.m_85836_();
        Vec3 cameraPosition = camera.m_90583_();
        poseStack.m_85837_((double)bp.m_123341_() - cameraPosition.f_82479_, (double)bp.m_123342_() - cameraPosition.f_82480_, (double)bp.m_123343_() - cameraPosition.f_82481_);
        level.m_7146_(bp);
        VertexConsumer buffer = buffers.m_6299_(RenderType.m_280070_());
        BlockPos.MutableBlockPos mutablepos = bp.m_122032_();
        for (Direction d : DIRECTIONS) {
            List culledFaces = model.getQuads(bs, d, randomsource, ModelData.EMPTY, null);
            mutablepos.m_122159_((Vec3i)bp, d);
            if (!Block.m_152444_((BlockState)bs, (BlockGetter)level, (BlockPos)bp, (Direction)d, (BlockPos)mutablepos)) continue;
            this.renderPreviewBlocks(poseStack, buffer, culledFaces);
        }
        this.renderPreviewBlocks(poseStack, buffer, model.getQuads(bs, null, randomsource, ModelData.EMPTY, null));
        poseStack.m_85849_();
        ((MultiBufferSource.BufferSource)buffers).m_109911_();
    }

    private void renderPreviewBlocks(PoseStack poseStack, VertexConsumer consumer, List<BakedQuad> quads) {
        for (BakedQuad bakedquad : quads) {
            int[] vertices = bakedquad.m_111303_();
            Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
            MemoryStack memorystack = MemoryStack.stackPush();
            try {
                ByteBuffer bytebuffer = memorystack.malloc(DefaultVertexFormat.f_85811_.m_86020_());
                IntBuffer intbuffer = bytebuffer.asIntBuffer();
                for (int k = 0; k < vertices.length / 8; ++k) {
                    intbuffer.clear();
                    intbuffer.put(vertices, k * 8, 8);
                    float f = bytebuffer.getFloat(0);
                    float f1 = bytebuffer.getFloat(4);
                    float f2 = bytebuffer.getFloat(8);
                    Vector4f vector4f = matrix4f.transform(new Vector4f(f, f1, f2, 1.0f));
                    consumer.m_5483_((double)vector4f.x(), (double)vector4f.y(), (double)vector4f.z());
                    consumer.m_6122_(255, 255, 255, 44);
                    consumer.m_5752_();
                }
            }
            finally {
                if (memorystack == null) continue;
                memorystack.close();
            }
        }
    }
}

