/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.events;

import com.google.common.collect.Multimap;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.event.ItemAttributeModifierEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.living.ShieldBlockEvent;
import net.minecraftforge.event.entity.player.PlayerFlyableFallEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.forgeevent.EntityStunEvent;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.api.utils.math.ValueModifier;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.mixin.common.MixinProjectile;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.server.SPPotion;
import yesman.epicfight.particle.EpicFightParticles;
import yesman.epicfight.particle.HitParticleType;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.EntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.HumanoidMobPatch;
import yesman.epicfight.world.capabilities.entitypatch.HurtableEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.mob.EndermanPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.projectile.ProjectilePatch;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.damagesource.EpicFightDamageTypeTags;
import yesman.epicfight.world.damagesource.StunType;
import yesman.epicfight.world.effect.EpicFightMobEffects;
import yesman.epicfight.world.entity.EpicFightEntities;
import yesman.epicfight.world.entity.eventlistener.DealDamageEvent;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;
import yesman.epicfight.world.entity.eventlistener.PlayerKilledEvent;
import yesman.epicfight.world.entity.eventlistener.ProjectileHitEvent;
import yesman.epicfight.world.entity.eventlistener.TakeDamageEvent;
import yesman.epicfight.world.gamerule.EpicFightGameRules;

@Mod.EventBusSubscriber(modid="epicfight")
public class EntityEvents {
    @SubscribeEvent
    public static void spawnEvent(EntityJoinLevelEvent event) {
        EpicFightCapabilities.getUnparameterizedEntityPatch(event.getEntity(), EntityPatch.class).ifPresent(entitypatch -> {
            if (!entitypatch.isInitialized()) {
                entitypatch.onJoinWorld(event.getEntity(), event);
            }
        });
    }

    @SubscribeEvent
    public static void updateEvent(LivingEvent.LivingTickEvent event) {
        EpicFightCapabilities.getUnparameterizedEntityPatch((Entity)event.getEntity(), HurtableEntityPatch.class).ifPresent(entitypatch -> {
            if (entitypatch.getOriginal() != null) {
                entitypatch.tick(event);
            }
        });
    }

    @SubscribeEvent
    public static void deathEvent(LivingDeathEvent event) {
        EpicFightCapabilities.getUnparameterizedEntityPatch((Entity)event.getEntity(), LivingEntityPatch.class).ifPresent(entitypatch -> entitypatch.onDeath(event));
        EpicFightCapabilities.getUnparameterizedEntityPatch(event.getSource().m_7639_(), ServerPlayerPatch.class).ifPresent(playerpatch -> playerpatch.getEventListener().triggerEvents(PlayerEventListener.EventType.PLAYER_KILLED_EVENT, new PlayerKilledEvent((ServerPlayerPatch)playerpatch, event.getEntity(), event.getSource())));
    }

    @SubscribeEvent
    public static void knockBackEvent(LivingKnockBackEvent event) {
        EpicFightCapabilities.getUnparameterizedEntityPatch((Entity)event.getEntity(), HurtableEntityPatch.class).ifPresent(entitypatch -> {
            if (entitypatch.shouldCancelKnockback()) {
                event.setCanceled(true);
            }
        });
    }

    @SubscribeEvent
    public static void hurtEvent(LivingHurtEvent event) {
        AssetAccessor<? extends StaticAnimation> fallAnimation;
        LivingEntityPatch entitypatch2;
        EpicFightDamageSource epicfightDamageSource = event.getSource() instanceof EpicFightDamageSource ? (EpicFightDamageSource)event.getSource() : null;
        ValueModifier.ResultCalculator damageCalculator = ValueModifier.calculator();
        Entity causingEntity = event.getSource().m_7639_();
        LivingEntity hitEntity = event.getEntity();
        EpicFightCapabilities.getUnparameterizedEntityPatch((Entity)hitEntity, ServerPlayerPatch.class).ifPresent(serverplayerpatch -> {
            TakeDamageEvent.Hurt hurtEvent = new TakeDamageEvent.Hurt((ServerPlayerPatch)serverplayerpatch, event.getSource(), damageCalculator, event.getAmount());
            serverplayerpatch.getEventListener().triggerEvents(PlayerEventListener.EventType.TAKE_DAMAGE_EVENT_HURT, hurtEvent);
        });
        if (causingEntity != null) {
            LivingEntityPatch attackerentitypatch = EpicFightCapabilities.getEntityPatch(causingEntity, LivingEntityPatch.class);
            if (attackerentitypatch != null) {
                event.setAmount(attackerentitypatch.getModifiedBaseDamage(event.getAmount()));
            }
            if (epicfightDamageSource != null) {
                if (attackerentitypatch instanceof ServerPlayerPatch) {
                    ServerPlayerPatch playerpatch = (ServerPlayerPatch)attackerentitypatch;
                    DealDamageEvent.Hurt dealDamageHurt = new DealDamageEvent.Hurt(playerpatch, hitEntity, epicfightDamageSource, event);
                    playerpatch.getEventListener().triggerEvents(PlayerEventListener.EventType.DEAL_DAMAGE_EVENT_HURT, dealDamageHurt);
                }
                if (epicfightDamageSource.m_269533_(EpicFightDamageTypeTags.EXECUTION)) {
                    EpicFightCapabilities.getUnparameterizedEntityPatch((Entity)hitEntity, LivingEntityPatch.class).ifPresentOrElse(entitypatch -> {
                        int executionResistance = entitypatch.getExecutionResistance();
                        if (executionResistance > 0) {
                            entitypatch.setExecutionResistance(executionResistance - 1);
                        } else {
                            event.setAmount(2.1474836E9f);
                        }
                    }, () -> event.setAmount(2.1474836E9f));
                }
            }
        }
        if (Float.compare(2.1474836E9f, event.getAmount()) != 0) {
            if (epicfightDamageSource != null) {
                epicfightDamageSource.attachDamageModifier(damageCalculator);
                float result = epicfightDamageSource.calculateDamageAgainst(causingEntity, hitEntity, event.getAmount());
                event.setAmount(result);
            } else {
                float result = damageCalculator.getResult(event.getAmount());
                event.setAmount(result);
            }
        }
        if (Float.compare(event.getAmount(), 0.0f) == 1 && epicfightDamageSource != null && !epicfightDamageSource.m_269533_(EpicFightDamageTypeTags.NO_STUN)) {
            EpicFightCapabilities.getUnparameterizedEntityPatch((Entity)hitEntity, HurtableEntityPatch.class).ifPresent(hitentitypatch -> {
                EntityStunEvent entityStunEvent;
                float impact;
                StunType stunType = epicfightDamageSource.getStunType();
                float stunTime = 0.0f;
                float knockBackAmount = 0.0f;
                float stunShield = hitentitypatch.getStunShield();
                if (stunShield > (impact = epicfightDamageSource.calculateImpact()) && (stunType == StunType.SHORT || stunType == StunType.LONG)) {
                    stunType = StunType.NONE;
                }
                if (MinecraftForge.EVENT_BUS.post((Event)(entityStunEvent = new EntityStunEvent(epicfightDamageSource, (HurtableEntityPatch<?>)hitentitypatch, stunType)))) {
                    return;
                }
                hitentitypatch.setStunShield(stunShield - impact);
                switch (stunType) {
                    case SHORT: {
                        stunType = StunType.NONE;
                        if (hitEntity.m_21023_((MobEffect)EpicFightMobEffects.STUN_IMMUNITY.get()) || hitentitypatch.getStunShield() != 0.0f) break;
                        float totalStunTime = (0.25f + impact * 0.1f) * (1.0f - hitentitypatch.getStunReduction());
                        if (totalStunTime >= 0.075f) {
                            stunTime = totalStunTime - 0.1f;
                            boolean isLongStun = totalStunTime >= 0.83f;
                            stunTime = isLongStun ? 0.83f : stunTime;
                            stunType = isLongStun ? StunType.LONG : StunType.SHORT;
                            knockBackAmount = Math.min(isLongStun ? impact * 0.05f : totalStunTime, 2.0f);
                        }
                        stunTime = (float)((double)stunTime * (1.0 - hitEntity.m_21133_(Attributes.f_22278_)));
                        break;
                    }
                    case LONG: {
                        stunType = hitEntity.m_21023_((MobEffect)EpicFightMobEffects.STUN_IMMUNITY.get()) ? StunType.NONE : StunType.LONG;
                        knockBackAmount = Math.min(impact * 0.05f, 5.0f);
                        stunTime = 0.83f;
                        break;
                    }
                    case HOLD: {
                        stunType = StunType.SHORT;
                        stunTime = impact * 0.25f;
                        break;
                    }
                    case KNOCKDOWN: {
                        stunType = hitEntity.m_21023_((MobEffect)EpicFightMobEffects.STUN_IMMUNITY.get()) ? StunType.NONE : StunType.KNOCKDOWN;
                        knockBackAmount = Math.min(impact * 0.05f, 5.0f);
                        stunTime = 2.0f;
                        break;
                    }
                    case NEUTRALIZE: {
                        stunType = StunType.NEUTRALIZE;
                        hitentitypatch.playSound((SoundEvent)EpicFightSounds.NEUTRALIZE_MOBS.get(), 3.0f, 0.0f, 0.1f);
                        ((HitParticleType)((Object)((Object)EpicFightParticles.AIR_BURST.get()))).spawnParticleWithArgument((ServerLevel)hitEntity.m_9236_(), (Entity)hitEntity, event.getSource().m_7640_());
                        knockBackAmount = 0.0f;
                        stunTime = 2.0f;
                    }
                }
                Vec3 sourcePosition = epicfightDamageSource.getInitialPosition();
                hitentitypatch.setStunReductionOnHit(stunType);
                boolean stunApplied = hitentitypatch.applyStun(stunType, stunTime);
                if (sourcePosition != null) {
                    if (!(hitEntity instanceof Player) && stunApplied) {
                        hitEntity.m_7618_(EntityAnchorArgument.Anchor.FEET, sourcePosition);
                    }
                    if (knockBackAmount > 0.0f) {
                        hitentitypatch.knockBackEntity(sourcePosition, knockBackAmount *= 40.0f / hitentitypatch.getWeight());
                    }
                }
            });
        }
        if (event.getSource().m_276093_(DamageTypes.f_268671_) && event.getAmount() > 1.0f && EpicFightGameRules.HAS_FALL_ANIMATION.getRuleValue(event.getEntity().m_9236_()).booleanValue() && (entitypatch2 = EpicFightCapabilities.getEntityPatch((Entity)event.getEntity(), LivingEntityPatch.class)) != null && !entitypatch2.getEntityState().inaction() && (fallAnimation = ((Animator)entitypatch2.getAnimator()).getLivingAnimation(LivingMotions.LANDING_RECOVERY, entitypatch2.getHitAnimation(StunType.FALL))) != null) {
            entitypatch2.playAnimationSynchronized(fallAnimation, 0.0f);
        }
    }

    @SubscribeEvent
    public static void damageEvent(LivingDamageEvent event) {
        EpicFightCapabilities.getUnparameterizedEntityPatch(event.getSource().m_7639_(), ServerPlayerPatch.class).ifPresent(playerpatch -> {
            DamageSource patt13826$temp = event.getSource();
            if (patt13826$temp instanceof EpicFightDamageSource) {
                EpicFightDamageSource epicFightDamageSource = (EpicFightDamageSource)patt13826$temp;
                playerpatch.getEventListener().triggerEvents(PlayerEventListener.EventType.DEAL_DAMAGE_EVENT_DAMAGE, new DealDamageEvent.Damage((ServerPlayerPatch)playerpatch, event.getEntity(), epicFightDamageSource, event));
            }
        });
        EpicFightCapabilities.getUnparameterizedEntityPatch((Entity)event.getEntity(), ServerPlayerPatch.class).ifPresent(playerpatch -> playerpatch.getEventListener().triggerEvents(PlayerEventListener.EventType.TAKE_DAMAGE_EVENT_DAMAGE, new TakeDamageEvent.Damage((ServerPlayerPatch)playerpatch, event.getSource(), event.getAmount())));
    }

    @SubscribeEvent
    public static void attackEvent(LivingAttackEvent event) {
        LivingEntityPatch entitypatch;
        if (event.getEntity().m_9236_().m_5776_()) {
            return;
        }
        if (event.getEntity().m_6673_(event.getSource())) {
            return;
        }
        if (event.getEntity().f_19802_ > 10 && event.getAmount() <= event.getEntity().f_20898_) {
            return;
        }
        if (event.getEntity().m_21223_() <= 0.0f) {
            return;
        }
        DamageSource damageSource = event.getSource();
        if (damageSource instanceof EpicFightDamageSource) {
            EpicFightDamageSource epicfightDamagesource = (EpicFightDamageSource)damageSource;
            damageSource = event.getSource().m_7639_();
            if (damageSource instanceof ServerPlayer) {
                ServerPlayer serverplayer = (ServerPlayer)damageSource;
                ServerPlayerPatch playerpatch = EpicFightCapabilities.getEntityPatch((Entity)serverplayer, ServerPlayerPatch.class);
                DealDamageEvent.Attack dealDamageAttack = new DealDamageEvent.Attack(playerpatch, event.getEntity(), epicfightDamagesource, event);
                playerpatch.getEventListener().triggerEvents(PlayerEventListener.EventType.DEAL_DAMAGE_EVENT_ATTACK, dealDamageAttack);
                if (dealDamageAttack.isCanceled()) {
                    event.setCanceled(true);
                    return;
                }
            }
        }
        AttackResult result = (entitypatch = EpicFightCapabilities.getEntityPatch((Entity)event.getEntity(), LivingEntityPatch.class)) != null ? entitypatch.tryHurt(event.getSource(), event.getAmount()) : AttackResult.success(event.getAmount());
        EpicFightCapabilities.getUnparameterizedEntityPatch(event.getSource().m_7639_(), LivingEntityPatch.class).ifPresent(attackerentitypatch -> attackerentitypatch.setLastAttackResult(result));
        if (!result.resultType.dealtDamage()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void shieldEvent(ShieldBlockEvent event) {
        EpicFightCapabilities.getParameterizedEntityPatch((Entity)event.getEntity(), LivingEntity.class, LivingEntityPatch.class).ifPresent(entitypatch -> entitypatch.playAnimationSynchronized(Animations.BIPED_HIT_SHIELD, 0.0f));
    }

    @SubscribeEvent
    public static void dropEvent(LivingDropsEvent event) {
        EpicFightCapabilities.getUnparameterizedEntityPatch((Entity)event.getEntity(), LivingEntityPatch.class).ifPresent(entitypatch -> {
            if (entitypatch.onDrop(event)) {
                event.setCanceled(true);
            }
        });
    }

    @SubscribeEvent
    public static void projectileImpactEvent(ProjectileImpactEvent event) {
        EntityHitResult entityHitResult;
        HitResult hitResult;
        ProjectilePatch projectilepatch = EpicFightCapabilities.getEntityPatch(event.getEntity(), ProjectilePatch.class);
        if (projectilepatch != null && projectilepatch.onProjectileImpact(event)) {
            event.setImpactResult(ProjectileImpactEvent.ImpactResult.SKIP_ENTITY);
        }
        if (event.getImpactResult() != ProjectileImpactEvent.ImpactResult.SKIP_ENTITY && (hitResult = event.getRayTraceResult()) instanceof EntityHitResult && (entityHitResult = (EntityHitResult)hitResult).m_82443_() != null) {
            Entity entity;
            EpicFightCapabilities.getUnparameterizedEntityPatch(entityHitResult.m_82443_(), PlayerPatch.class).ifPresent(playerpatch -> {
                playerpatch.getEntityState().setProjectileImpactResult(event);
                if (event.getImpactResult() == ProjectileImpactEvent.ImpactResult.DEFAULT && playerpatch instanceof ServerPlayerPatch) {
                    ServerPlayerPatch serverplayerpatch = (ServerPlayerPatch)playerpatch;
                    boolean canceled = playerpatch.getEventListener().triggerEvents(PlayerEventListener.EventType.PROJECTILE_HIT_EVENT, new ProjectileHitEvent(serverplayerpatch, event));
                    if (canceled) {
                        event.setImpactResult(ProjectileImpactEvent.ImpactResult.SKIP_ENTITY);
                    }
                }
            });
            if (event.getProjectile().m_19749_() != null) {
                if (entityHitResult.m_82443_().equals((Object)event.getProjectile().m_19749_().m_20202_())) {
                    event.setImpactResult(ProjectileImpactEvent.ImpactResult.SKIP_ENTITY);
                }
                if ((entity = entityHitResult.m_82443_()) instanceof PartEntity) {
                    PartEntity partEntity = (PartEntity)entity;
                    Entity parent = partEntity.getParent();
                    if (event.getProjectile().m_19749_().m_7306_(parent)) {
                        event.setImpactResult(ProjectileImpactEvent.ImpactResult.SKIP_ENTITY);
                    }
                }
            }
            if (((EntityType)EpicFightEntities.DODGE_LOCATION_INDICATOR.get()).equals(entityHitResult.m_82443_().m_6095_())) {
                entity = event.getEntity();
                if (entity instanceof Projectile) {
                    Projectile projectile = (Projectile)entity;
                    ((MixinProjectile)projectile).invoke_onHitEntity(entityHitResult);
                }
                event.setImpactResult(ProjectileImpactEvent.ImpactResult.SKIP_ENTITY);
            }
        }
        if (projectilepatch != null && event.getImpactResult() == ProjectileImpactEvent.ImpactResult.DEFAULT) {
            projectilepatch.setHit(true);
        }
    }

    @SubscribeEvent
    public static void itemAttributeModifierEvent(ItemAttributeModifierEvent event) {
        CapabilityItem itemCap = EpicFightCapabilities.getItemStackCapability(event.getItemStack());
        if (!itemCap.isEmpty()) {
            Multimap<Attribute, AttributeModifier> multimap = itemCap.getAttributeModifiers(event.getSlotType(), null);
            for (Attribute key : multimap.keys()) {
                for (AttributeModifier modifier : multimap.get((Object)key)) {
                    event.addModifier(key, modifier);
                }
            }
        }
    }

    @SubscribeEvent
    public static void equipChangeEvent(LivingEquipmentChangeEvent event) {
        EpicFightCapabilities.getUnparameterizedEntityPatch((Entity)event.getEntity(), HurtableEntityPatch.class).ifPresent(hurtableEntitypatch -> hurtableEntitypatch.setDefaultStunReduction(event.getSlot(), event.getFrom(), event.getTo()));
        LivingEntityPatch entitypatch = EpicFightCapabilities.getEntityPatch((Entity)event.getEntity(), LivingEntityPatch.class);
        CapabilityItem fromCap = EpicFightCapabilities.getItemStackCapability(event.getFrom());
        CapabilityItem toCap = EpicFightCapabilities.getItemStackCapability(event.getTo());
        if (event.getSlot() != EquipmentSlot.OFFHAND) {
            if (fromCap != null) {
                event.getEntity().m_21204_().m_22161_(fromCap.getAttributeModifiers(event.getSlot(), entitypatch));
            }
            if (toCap != null) {
                event.getEntity().m_21204_().m_22178_(toCap.getAttributeModifiers(event.getSlot(), entitypatch));
            }
        }
        if (entitypatch != null && entitypatch.getOriginal() != null) {
            if (event.getSlot().m_20743_() == EquipmentSlot.Type.HAND) {
                InteractionHand hand = event.getSlot() == EquipmentSlot.MAINHAND ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
                entitypatch.updateHeldItem(fromCap, toCap, event.getFrom(), event.getTo(), hand);
            } else if (event.getSlot().m_20743_() == EquipmentSlot.Type.ARMOR) {
                entitypatch.updateArmor(fromCap, toCap, event.getSlot());
            }
        }
    }

    @SubscribeEvent
    public static void sizingEvent(EntityEvent.Size event) {
        if (event.getEntity() instanceof EnderDragon) {
            event.setNewSize(EntityDimensions.m_20395_((float)5.0f, (float)3.0f));
        }
    }

    @SubscribeEvent
    public static void effectAddEvent(MobEffectEvent.Added event) {
        if (!event.getEntity().m_9236_().m_5776_()) {
            EpicFightNetworkManager.sendToAll(new SPPotion(event.getEffectInstance(), SPPotion.Action.ACTIVATE, event.getEntity().m_19879_()), new Object[0]);
        }
    }

    @SubscribeEvent
    public static void effectRemoveEvent(MobEffectEvent.Remove event) {
        if (!event.getEntity().m_9236_().m_5776_() && event.getEffectInstance() != null) {
            EpicFightNetworkManager.sendToAll(new SPPotion(event.getEffectInstance(), SPPotion.Action.REMOVE, event.getEntity().m_19879_()), new Object[0]);
        }
    }

    @SubscribeEvent
    public static void effectExpiryEvent(MobEffectEvent.Expired event) {
        if (!event.getEntity().m_9236_().m_5776_()) {
            EpicFightNetworkManager.sendToAll(new SPPotion(event.getEffectInstance(), SPPotion.Action.REMOVE, event.getEntity().m_19879_()), new Object[0]);
        }
    }

    @SubscribeEvent
    public static void mountEvent(EntityMountEvent event) {
        EpicFightCapabilities.getUnparameterizedEntityPatch(event.getEntityMounting(), HumanoidMobPatch.class).ifPresent(humanoidMobPatch -> {
            if (!event.getLevel().m_5776_() && humanoidMobPatch.getOriginal() != null && event.getEntityBeingMounted() instanceof Mob) {
                humanoidMobPatch.onMount(event.isMounting(), event.getEntityBeingMounted());
            }
        });
    }

    @SubscribeEvent
    public static void tpEvent(EntityTeleportEvent.EnderEntity event) {
        EpicFightCapabilities.getUnparameterizedEntityPatch(event.getEntity(), EndermanPatch.class).ifPresent(enderManPatch -> {
            if (enderManPatch.getEntityState().inaction()) {
                for (Entity collideEntity : ((EnderMan)enderManPatch.getOriginal()).m_9236_().m_45976_(Entity.class, ((EnderMan)enderManPatch.getOriginal()).m_20191_().m_82377_(0.2, 0.2, 0.2))) {
                    if (!(collideEntity instanceof Projectile)) continue;
                    return;
                }
                event.setCanceled(true);
            } else if (enderManPatch.isRaging()) {
                event.setCanceled(true);
            }
        });
    }

    @SubscribeEvent
    public static void jumpEvent(LivingEvent.LivingJumpEvent event) {
        EpicFightCapabilities.getParameterizedEntityPatch((Entity)event.getEntity(), LivingEntity.class, LivingEntityPatch.class).ifPresent(entitypatch -> {
            if (entitypatch.isLogicalClient() && !entitypatch.getEntityState().inaction() && !event.getEntity().m_20069_()) {
                AssetAccessor<? extends StaticAnimation> jumpAnimation = entitypatch.getClientAnimator().getJumpAnimation();
                entitypatch.playAnimationInClientSide(jumpAnimation, 0.0f);
            }
        });
    }

    @SubscribeEvent
    public static void fallEvent(LivingFallEvent event) {
        EpicFightCapabilities.getUnparameterizedEntityPatch((Entity)event.getEntity(), LivingEntityPatch.class).ifPresent(entitypatch -> entitypatch.onFall(event));
    }

    @SubscribeEvent
    public static void playerFallEvent(PlayerFlyableFallEvent event) {
        EpicFightCapabilities.getParameterizedEntityPatch((Entity)event.getEntity(), Player.class, PlayerPatch.class).ifPresent(entitypatch -> entitypatch.onFall(new LivingFallEvent((LivingEntity)event.getEntity(), event.getDistance(), event.getMultiplier())));
    }
}

