/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.network.client;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryManager;
import yesman.epicfight.api.data.reloader.SkillManager;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.server.SPSetRemotePlayerSkill;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;

public class CPChangeSkill {
    private final SkillSlot skillSlot;
    private final int itemSlotIndex;
    private final boolean consumeXp;
    @Nullable
    private final Skill skill;

    public CPChangeSkill() {
        this(null, -1, false, null);
    }

    public CPChangeSkill(SkillSlot skillSlot, int itemSlotIndex, boolean consumeXp, @Nullable Skill skill) {
        this.skillSlot = skillSlot;
        this.itemSlotIndex = itemSlotIndex;
        this.consumeXp = consumeXp;
        this.skill = skill;
    }

    public static CPChangeSkill fromBytes(FriendlyByteBuf buf) {
        return new CPChangeSkill(SkillSlot.ENUM_MANAGER.get(buf.readInt()), buf.readInt(), buf.readBoolean(), buf.isReadable() ? (Skill)buf.readRegistryId() : null);
    }

    public static void toBytes(CPChangeSkill msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.skillSlot.universalOrdinal());
        buf.writeInt(msg.itemSlotIndex);
        buf.writeBoolean(msg.consumeXp);
        if (msg.skill != null) {
            buf.writeRegistryId((IForgeRegistry)RegistryManager.ACTIVE.getRegistry(SkillManager.SKILL_REGISTRY_KEY), (Object)msg.skill);
        }
    }

    public static void handle(CPChangeSkill msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> EpicFightCapabilities.getUnparameterizedEntityPatch((Entity)((NetworkEvent.Context)ctx.get()).getSender(), ServerPlayerPatch.class).ifPresent(playerpatch -> {
            boolean skillEquipped = playerpatch.getSkill(msg.skillSlot).setSkill(msg.skill);
            if (msg.skill != null) {
                if (msg.skill.getCategory().learnable()) {
                    playerpatch.getSkillCapability().addLearnedSkill(msg.skill);
                }
                if (msg.consumeXp) {
                    ((ServerPlayer)playerpatch.getOriginal()).m_6749_(-msg.skill.getRequiredXp());
                } else if (msg.itemSlotIndex >= 0 && !((ServerPlayer)playerpatch.getOriginal()).m_7500_()) {
                    ((ServerPlayer)playerpatch.getOriginal()).m_150109_().m_36057_(((ServerPlayer)playerpatch.getOriginal()).m_150109_().m_8020_(msg.itemSlotIndex));
                }
            }
            if (skillEquipped) {
                EpicFightNetworkManager.sendToAllPlayerTrackingThisEntity(new SPSetRemotePlayerSkill(((ServerPlayer)playerpatch.getOriginal()).m_19879_(), msg.skillSlot, msg.skill), playerpatch.getOriginal(), new Object[0]);
            }
        }));
        ctx.get().setPacketHandled(true);
    }
}

