/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.network.client;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;

public class CPSkillRequest {
    private final SkillSlot skillSlot;
    private final WorkType workType;
    private final FriendlyByteBuf buffer;

    public CPSkillRequest(SkillSlot skillSlot) {
        this(skillSlot, WorkType.CAST);
    }

    public CPSkillRequest(SkillSlot skillSlot, WorkType active) {
        this.skillSlot = skillSlot;
        this.workType = active;
        this.buffer = new FriendlyByteBuf(Unpooled.buffer());
    }

    public CPSkillRequest(SkillSlot skillSlot, WorkType active, FriendlyByteBuf pb) {
        this.skillSlot = skillSlot;
        this.workType = active;
        this.buffer = new FriendlyByteBuf(Unpooled.buffer());
        if (pb != null) {
            this.buffer.writeBytes((ByteBuf)pb);
        }
    }

    public FriendlyByteBuf getBuffer() {
        return this.buffer;
    }

    public static CPSkillRequest fromBytes(FriendlyByteBuf buf) {
        CPSkillRequest msg = new CPSkillRequest(SkillSlot.ENUM_MANAGER.getOrThrow(buf.readInt()), (WorkType)buf.m_130066_(WorkType.class));
        while (buf.isReadable()) {
            msg.buffer.writeByte((int)buf.readByte());
        }
        return msg;
    }

    public static void toBytes(CPSkillRequest msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.skillSlot.universalOrdinal());
        buf.m_130068_((Enum)msg.workType);
        while (msg.buffer.isReadable()) {
            buf.writeByte((int)msg.buffer.readByte());
        }
    }

    public static void handle(CPSkillRequest msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> EpicFightCapabilities.getUnparameterizedEntityPatch((Entity)((NetworkEvent.Context)ctx.get()).getSender(), ServerPlayerPatch.class).ifPresent(playerpatch -> {
            SkillContainer skillContainer = playerpatch.getSkill(msg.skillSlot);
            switch (msg.workType) {
                case CAST: {
                    skillContainer.requestCasting((ServerPlayerPatch)playerpatch, msg.getBuffer());
                    break;
                }
                case CANCEL: {
                    skillContainer.requestCancel((ServerPlayerPatch)playerpatch, msg.getBuffer());
                    break;
                }
                case HOLD_START: {
                    skillContainer.requestHold((ServerPlayerPatch)playerpatch, msg.getBuffer());
                }
            }
        }));
        ctx.get().setPacketHandled(true);
    }

    public static enum WorkType {
        CAST,
        CANCEL,
        HOLD_START;

    }
}

