/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.entity.ai.brain;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.CrossbowItem;
import yesman.epicfight.main.EpicFightMod;
import yesman.epicfight.world.entity.ai.behavior.AnimatedCombatBehavior;
import yesman.epicfight.world.entity.ai.behavior.BackUpIfTooCloseStopInaction;
import yesman.epicfight.world.entity.ai.behavior.MoveToTargetSinkStopInaction;

public final class BrainRecomposer {
    private static final Map<EntityType<?>, BrainRecomposeFunction> BRAIN_REPLACE_DEST_MAPPER = ImmutableMap.of((Object)EntityType.f_20511_, BrainRecomposer::recomposePiglinBrain, (Object)EntityType.f_20512_, BrainRecomposer::recomposePiglinBruteBrain, (Object)EntityType.f_20456_, BrainRecomposer::recomposeHoglinBrain, (Object)EntityType.f_20500_, BrainRecomposer::recomposeZoglinBrain);

    public static void recomposeBrainByType(EntityType<?> entityType, Brain<?> brain, AnimatedCombatBehavior<?> animatedCombatBehavior, MoveToTargetSinkStopInaction chaseBehavior) {
        BrainRecomposeFunction brainRecomposeFunction = BRAIN_REPLACE_DEST_MAPPER.get(entityType);
        if (brainRecomposeFunction == null) {
            EpicFightMod.LOGGER.error("Failed to find brain recompose function for entity type: {}", entityType);
            return;
        }
        brainRecomposeFunction.recomposeBrain(brain, animatedCombatBehavior, chaseBehavior);
    }

    public static void recomposePiglinBrain(Brain<?> brain, AnimatedCombatBehavior<?> animatedCombatBehavior, MoveToTargetSinkStopInaction chaseBehavior) {
        if (animatedCombatBehavior != null) {
            BrainRecomposer.replaceBehavior(brain, Activity.f_37988_, 13, animatedCombatBehavior, new Class[]{OneShot.class, AnimatedCombatBehavior.class});
        }
        BrainRecomposer.replaceBehavior(brain, Activity.f_37988_, 11, BehaviorBuilder.m_257845_(entity -> entity.m_21093_(is -> is.m_41720_() instanceof CrossbowItem), BackUpIfTooCloseStopInaction.create(5, 0.75f)), new Class[]{OneShot.class});
        BrainRecomposer.replaceBehavior(brain, Activity.f_37978_, 1, chaseBehavior, new Class[]{MoveToTargetSink.class, MoveToTargetSinkStopInaction.class});
        BrainRecomposer.removeBehavior(brain, Activity.f_37989_, 15, RunOne.class);
    }

    public static void recomposePiglinBruteBrain(Brain<?> brain, AnimatedCombatBehavior<?> animatedCombatBehavior, MoveToTargetSinkStopInaction chaseBehavior) {
        if (animatedCombatBehavior != null) {
            BrainRecomposer.replaceBehavior(brain, Activity.f_37988_, 12, animatedCombatBehavior, new Class[]{OneShot.class, AnimatedCombatBehavior.class});
        }
        BrainRecomposer.replaceBehavior(brain, Activity.f_37978_, 1, chaseBehavior, new Class[]{MoveToTargetSink.class, MoveToTargetSinkStopInaction.class});
    }

    public static void recomposeHoglinBrain(Brain<?> brain, AnimatedCombatBehavior<?> animatedCombatBehavior, MoveToTargetSinkStopInaction chaseBehavior) {
        BrainRecomposer.replaceBehavior(brain, Activity.f_37978_, 1, chaseBehavior, new Class[]{MoveToTargetSink.class, MoveToTargetSinkStopInaction.class});
        BrainRecomposer.replaceBehavior(brain, Activity.f_37988_, 13, animatedCombatBehavior, new Class[]{OneShot.class});
        BrainRecomposer.removeBehavior(brain, Activity.f_37988_, 14, OneShot.class);
    }

    public static void recomposeZoglinBrain(Brain<?> brain, AnimatedCombatBehavior<?> animatedCombatBehavior, MoveToTargetSinkStopInaction chaseBehavior) {
        BrainRecomposer.replaceBehavior(brain, Activity.f_37978_, 1, chaseBehavior, new Class[]{MoveToTargetSink.class, MoveToTargetSinkStopInaction.class});
        BrainRecomposer.replaceBehavior(brain, Activity.f_37988_, 11, animatedCombatBehavior, new Class[]{OneShot.class});
        BrainRecomposer.removeBehavior(brain, Activity.f_37988_, 12, OneShot.class);
    }

    public static <E extends LivingEntity> void removeBehavior(Brain<E> brain, Activity activity, int priority, Class<?> targetBehaviorClass) {
        Set set = (Set)((Map)brain.f_21845_.get(priority)).get(activity);
        set.removeIf(behavior -> targetBehaviorClass.isInstance(behavior));
    }

    @SafeVarargs
    public static <E extends LivingEntity> void replaceBehavior(Brain<E> brain, Activity activity, int priority, BehaviorControl<?> newBehavior, Class<?> ... targetClasses) {
        Set set = (Set)((Map)brain.f_21845_.get(priority)).get(activity);
        boolean removed = set.removeIf(behavior -> BrainRecomposer.contains(behavior, targetClasses));
        if (removed) {
            set.add(newBehavior);
        }
    }

    @SafeVarargs
    private static <E extends LivingEntity> boolean contains(Object behavior, Class<?> ... targetClasses) {
        for (Class<?> targetClass : targetClasses) {
            if (!targetClass.isAssignableFrom(behavior.getClass())) continue;
            return true;
        }
        return false;
    }

    private BrainRecomposer() {
    }

    @FunctionalInterface
    public static interface BrainRecomposeFunction {
        public void recomposeBrain(Brain<?> var1, AnimatedCombatBehavior<?> var2, MoveToTargetSinkStopInaction var3);
    }
}

