/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.gamerule;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeConfigSpec;
import yesman.epicfight.api.utils.PacketBufferCodec;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.server.SPChangeGamerule;

public class EpicFightGameRules {
    public static final ConfigurableGameRule<Boolean, ForgeConfigSpec.BooleanValue, GameRules.BooleanValue> GLOBAL_STUN = EpicFightGameRules.create("globalStun", GameRules.Category.MOBS, configBuilder -> configBuilder.define("default_gamerule.globalStun", true), RuleType.BOOLEAN, false);
    public static final ConfigurableGameRule<Boolean, ForgeConfigSpec.BooleanValue, GameRules.BooleanValue> KEEP_SKILLS = EpicFightGameRules.create("keepSkills", GameRules.Category.PLAYER, configBuilder -> configBuilder.define("default_gamerule.keepSkills", true), RuleType.BOOLEAN, false);
    public static final ConfigurableGameRule<Boolean, ForgeConfigSpec.BooleanValue, GameRules.BooleanValue> HAS_FALL_ANIMATION = EpicFightGameRules.create("hasFallAnimation", GameRules.Category.PLAYER, configBuilder -> configBuilder.define("default_gamerule.hasFallAnimation", true), RuleType.BOOLEAN, true);
    public static final ConfigurableGameRule<Boolean, ForgeConfigSpec.BooleanValue, GameRules.BooleanValue> DISABLE_ENTITY_UI = EpicFightGameRules.create("disableEntityUI", GameRules.Category.MISC, configBuilder -> configBuilder.define("default_gamerule.disapleEntityUI", false), RuleType.BOOLEAN, true);
    public static final ConfigurableGameRule<Boolean, ForgeConfigSpec.BooleanValue, GameRules.BooleanValue> CAN_SWITCH_PLAYER_MODE = EpicFightGameRules.create("canSwitchPlayerMode", GameRules.Category.PLAYER, configBuilder -> configBuilder.define("default_gamerule.canSwitchPlayerMode", true), RuleType.BOOLEAN, true);
    public static final ConfigurableGameRule<Boolean, ForgeConfigSpec.BooleanValue, GameRules.BooleanValue> STIFF_COMBO_ATTACKS = EpicFightGameRules.create("stiffComboAttacks", GameRules.Category.PLAYER, configBuilder -> configBuilder.define("default_gamerule.stiffComboAttacks", true), RuleType.BOOLEAN, true);
    public static final ConfigurableGameRule<Boolean, ForgeConfigSpec.BooleanValue, GameRules.BooleanValue> NO_MOBS_IN_BOSSFIGHT = EpicFightGameRules.create("noMobsInBossfight", GameRules.Category.SPAWNING, configBuilder -> configBuilder.define("default_gamerule.noMobsInBossfight", true), RuleType.BOOLEAN, true);
    public static final ConfigurableGameRule<Integer, ForgeConfigSpec.IntValue, GameRules.IntegerValue> INITIAL_PLAYER_MODE = EpicFightGameRules.create("initialMode", GameRules.Category.PLAYER, configBuilder -> configBuilder.comment("0 = vanilla, 1 = epicfight").defineInRange("default_gamerule.initialMode", 1, 0, 1), RuleType.INTEGER, true);
    public static final ConfigurableGameRule<Integer, ForgeConfigSpec.IntValue, GameRules.IntegerValue> WEIGHT_PENALTY = EpicFightGameRules.create("weightPenalty", GameRules.Category.PLAYER, configBuilder -> configBuilder.defineInRange("default_gamerule.weightPenalty", 100, 0, 100), RuleType.INTEGER, true);
    public static final ConfigurableGameRule<Boolean, ForgeConfigSpec.BooleanValue, GameRules.BooleanValue> EPIC_DROP = EpicFightGameRules.create("epicDrop", GameRules.Category.DROPS, configBuilder -> configBuilder.define("default_gamerule.epicDrop", false), RuleType.BOOLEAN, true);
    public static final Map<String, ConfigurableGameRule<?, ?, ?>> GAME_RULES = ImmutableMap.builder().put((Object)"globalStun", GLOBAL_STUN).put((Object)"keepSkills", KEEP_SKILLS).put((Object)"hasFallAnimation", HAS_FALL_ANIMATION).put((Object)"disableEntityUI", DISABLE_ENTITY_UI).put((Object)"canSwitchPlayerMode", CAN_SWITCH_PLAYER_MODE).put((Object)"stiffComboAttacks", STIFF_COMBO_ATTACKS).put((Object)"noMobsInBossfight", NO_MOBS_IN_BOSSFIGHT).put((Object)"initialMode", INITIAL_PLAYER_MODE).put((Object)"weightPenalty", WEIGHT_PENALTY).put((Object)"epicDrop", EPIC_DROP).build();

    public static void registerGameRules() {
        GAME_RULES.values().forEach(gamerule -> gamerule.registerGameRule());
    }

    public static <Type, Config extends ForgeConfigSpec.ConfigValue<Type>, RuleValue extends GameRules.Value<RuleValue>> ConfigurableGameRule<Type, Config, RuleValue> create(String ruleName, GameRules.Category ruleCategory, Function<ForgeConfigSpec.Builder, Config> configDefinition, RuleType<Type, RuleValue> ruleType, boolean synchronize) {
        return new ConfigurableGameRule<Type, Config, RuleValue>(ruleName, ruleCategory, configDefinition, ruleType, synchronize);
    }

    public static class ConfigurableGameRule<Type, Config extends ForgeConfigSpec.ConfigValue<Type>, RuleValue extends GameRules.Value<RuleValue>> {
        final String ruleName;
        final GameRules.Category ruleCategory;
        final Function<ForgeConfigSpec.Builder, Config> configDefinition;
        final RuleType<Type, RuleValue> ruleType;
        final boolean synchronize;
        Config configValueHolder;
        GameRules.Key<RuleValue> gameRuleKey;

        private ConfigurableGameRule(String ruleName, GameRules.Category ruleCategory, Function<ForgeConfigSpec.Builder, Config> configDefinition, RuleType<Type, RuleValue> ruleType, boolean synchronize) {
            this.ruleName = ruleName;
            this.ruleCategory = ruleCategory;
            this.configDefinition = configDefinition;
            this.ruleType = ruleType;
            this.synchronize = synchronize;
        }

        public void registerGameRule() {
            this.gameRuleKey = this.synchronize ? GameRules.m_46189_((String)this.ruleName, (GameRules.Category)this.ruleCategory, this.ruleType.valueCreator.apply(this.configValueHolder.get(), (server, value) -> EpicFightNetworkManager.sendToAll(new SPChangeGamerule(this, this.ruleType.getRule.apply(value)), new Object[0]))) : GameRules.m_46189_((String)this.ruleName, (GameRules.Category)this.ruleCategory, (GameRules.Type)((GameRules.Type)this.ruleType.valueCreatorUnsynchronized.apply(this.configValueHolder.get())));
        }

        public boolean shouldSync() {
            return this.synchronize;
        }

        public SPChangeGamerule<?, ?, ?> getSyncPacket(ServerPlayer player) {
            return new SPChangeGamerule(this, this.getRuleValue(player.m_9236_()));
        }

        public void defineConfig(ForgeConfigSpec.Builder configBuilder) {
            this.configValueHolder = (ForgeConfigSpec.ConfigValue)this.configDefinition.apply((Object)configBuilder);
        }

        public String getRuleName() {
            return this.ruleName;
        }

        public RuleType<Type, RuleValue> getRuleType() {
            return this.ruleType;
        }

        public GameRules.Key<RuleValue> getRuleKey() {
            return this.gameRuleKey;
        }

        public Config getConfigHolder() {
            return this.configValueHolder;
        }

        public Type getRuleValue(Level level) {
            return (Type)this.ruleType.getRule.apply((Object)level.m_46469_().m_46170_(this.gameRuleKey));
        }

        public void setRuleValue(Level level, Type value) {
            this.ruleType.setRule.accept(level.m_46469_().m_46170_(this.gameRuleKey), value);
        }
    }

    public record RuleType<Type, RuleValue extends GameRules.Value<RuleValue>>(BiFunction<Type, BiConsumer<MinecraftServer, RuleValue>, GameRules.Type<RuleValue>> valueCreator, Function<Type, GameRules.Type<RuleValue>> valueCreatorUnsynchronized, Function<RuleValue, Type> getRule, BiConsumer<RuleValue, Type> setRule, PacketBufferCodec<Type> bufferCodec) {
        private static final RuleType<Boolean, GameRules.BooleanValue> BOOLEAN = new RuleType<Boolean, GameRules.BooleanValue>(GameRules.BooleanValue::m_46252_, GameRules.BooleanValue::m_46250_, GameRules.BooleanValue::m_46223_, (ruleValue, value) -> ruleValue.m_46246_(value.booleanValue(), null), PacketBufferCodec.BOOLEAN);
        private static final RuleType<Integer, GameRules.IntegerValue> INTEGER = new RuleType<Integer, GameRules.IntegerValue>(GameRules.IntegerValue::m_46294_, GameRules.IntegerValue::m_46312_, GameRules.IntegerValue::m_46288_, (ruleValue, value) -> ruleValue.m_46314_(value.toString()), PacketBufferCodec.INTEGER);
    }
}

